/******************************************************************************
 * © 2020 SAP SE or an SAP affiliate company. All rights reserved.            *
 ******************************************************************************/
package com.sap.cloud.mt.runtime;

import com.sap.cloud.mt.runtime.DataPoolSettings.Parameter;
import com.sap.cloud.mt.subscription.DataSourceInfo;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.zaxxer.hikari.HikariDataSource;

import javax.sql.DataSource;
import java.util.Properties;
import java.util.stream.Stream;

public class DataSourceCreatorHikari extends DataSourceCreator {
    private final DataPoolSettings poolSettings;

    public DataSourceCreatorHikari(DataPoolSettings poolSettings) {
        this.poolSettings = poolSettings;
    }

    @Override
    protected DataSource build(DataSourceInfo info) throws InternalError {
        HikariDataSource hikariDataSource = new HikariDataSource();
        hikariDataSource.setDriverClassName(info.getDriver());
        hikariDataSource.setJdbcUrl(info.getUrl());
        hikariDataSource.setUsername(info.getUser());
        hikariDataSource.setPassword(info.getPassword());
        // Add database specific properties specified by the user
        Properties allDbProperties = hikariDataSource.getDataSourceProperties();
        if (allDbProperties == null) {
            allDbProperties = new Properties();
        }
        allDbProperties.putAll(poolSettings.getDbProperties(DataPoolSettings.ConnectionPoolType.HIKARI));
        hikariDataSource.setDataSourceProperties(allDbProperties);
        return hikariDataSource;
    }

    @Override
    protected Stream<Parameter> getPoolParameters() {
        return poolSettings.getHikariParameters();
    }
}
