/******************************************************************************
 * © 2020 SAP SE or an SAP affiliate company. All rights reserved.            *
 ******************************************************************************/
package com.sap.cloud.mt.runtime;

import com.sap.cloud.mt.subscription.DataSourceInfo;
import com.sap.cloud.mt.subscription.InstanceLifecycleManager;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.sql.DataSource;
import java.util.Locale;

@Deprecated
public class MtLibDataSourceLookup extends DataSourceLookup {
    private static Logger logger = LoggerFactory.getLogger(MtLibDataSourceLookup.class);
    private final String poolProvider;
    private final DataSourceLookup dataSourceLookup;


    public MtLibDataSourceLookup(InstanceLifecycleManager instanceLifecycleManager, String poolProvider, EnvironmentAccess environment,
                                 DataPoolSettings poolSettings, boolean oneDataSourcePerDb)
            throws InstantiationException {
        super(instanceLifecycleManager, oneDataSourcePerDb);
        this.poolProvider = poolProvider;
        switch (poolProvider.toLowerCase(Locale.ENGLISH)) {
            case "tomcat":
                dataSourceLookup = new TomcatDataSourceLookup(instanceLifecycleManager, environment, poolSettings,
                        oneDataSourcePerDb);
                break;
            case "hikari":
                dataSourceLookup = new HikariDataSourceLookup(instanceLifecycleManager, environment, poolSettings,
                        oneDataSourcePerDb);
                break;
            case "atomikos":
                dataSourceLookup = new AtomikosDataSourceLookup(instanceLifecycleManager, environment, poolSettings,
                        oneDataSourcePerDb);
                break;
            default:
                throw new InstantiationException("Pool provider " + poolProvider + " not supported");
        }
    }

    public MtLibDataSourceLookup(InstanceLifecycleManager instanceLifecycleManager, String poolProvider, EnvironmentAccess environment,
                                 DataPoolSettings poolSettings) throws InstantiationException {
        this(instanceLifecycleManager, poolProvider, environment, poolSettings, false);
    }

    @Override
    public DataSource create(DataSourceInfo info) throws InternalError {
        return dataSourceLookup.create(info);
    }

    @Override
    public void closeDataSource(DataSource dataSource) {
        dataSourceLookup.closeDataSource(dataSource);
    }
}
