/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.runtime;

import com.sap.cloud.mt.runtime.ConnectionProvider;
import com.sap.cloud.mt.runtime.GenericConnectionProvider;
import com.sap.cloud.mt.runtime.HanaConnectionProvider;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionProviderFunction
implements BiFunction<String, Boolean, ConnectionProvider> {
    private static final ConnectionProvider HANA_CONNECTION_PROVIDER = new HanaConnectionProvider();
    private static final ConnectionProvider GENERIC_CONNECTION_PROVIDER = new GenericConnectionProvider();
    private static final Logger logger = LoggerFactory.getLogger(ConnectionProviderFunction.class);
    private static final String USE_GENERIC_CONNECTION_PROVIDER = "Use generic connection provider";

    @Override
    public ConnectionProvider apply(String driver, Boolean onDataSourcePerDb) {
        if (onDataSourcePerDb == null) {
            onDataSourcePerDb = false;
        }
        switch (driver) {
            case "com.sap.db.jdbc.Driver": {
                if (onDataSourcePerDb.booleanValue()) {
                    logger.debug("Use HANA connection provider");
                    return HANA_CONNECTION_PROVIDER;
                }
                logger.debug(USE_GENERIC_CONNECTION_PROVIDER);
                return GENERIC_CONNECTION_PROVIDER;
            }
        }
        logger.debug(USE_GENERIC_CONNECTION_PROVIDER);
        return GENERIC_CONNECTION_PROVIDER;
    }
}

