/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.runtime;

import com.sap.cloud.mt.runtime.DbUtils;
import com.sap.cloud.mt.runtime.HealtCheckResult;
import com.sap.cloud.mt.runtime.TenantAwareDataSource;
import com.sap.cloud.mt.subscription.DataSourceInfo;
import com.sap.cloud.mt.subscription.DbIdentifiers;
import com.sap.cloud.mt.subscription.SqlOperations;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.cloud.mt.subscription.exceptions.ParameterException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbHealthIndicatorImpl<T> {
    private static final Logger logger = LoggerFactory.getLogger(DbHealthIndicatorImpl.class);
    private static final int STACK_TRACE_WRITE_PERIOD = 100;
    private final TenantAwareDataSource dataSource;
    private volatile long lastChecked = 0L;
    private volatile T lastHealth = null;
    private final Long healthCheckIntervalMillis;
    private final HealthUp<T> healthUp;
    private final HealthDown<T> healthDown;
    private final HealthDownDetails<T> healthDownDetails;
    private final HealthUpDetails<T> healthUpDetails;
    private volatile int callCounter = 0;
    private final ReentrantLock lock = new ReentrantLock();
    private final SqlOperations sqlOperations;
    private final String healthDummySelect;

    public DbHealthIndicatorImpl(String healthDummySelect, TenantAwareDataSource dataSource, Long healthCheckIntervalMillis, HealthUp<T> healthUp, HealthDown<T> healthDown, HealthDownDetails<T> healthDownDetails, HealthUpDetails<T> healthUpDetails) {
        this.healthDummySelect = healthDummySelect;
        this.dataSource = dataSource;
        this.healthCheckIntervalMillis = healthCheckIntervalMillis;
        this.healthUp = healthUp;
        this.healthDown = healthDown;
        this.healthDownDetails = healthDownDetails;
        this.healthUpDetails = healthUpDetails;
        try {
            this.sqlOperations = dataSource.getDbType() != null ? SqlOperations.build((DbIdentifiers.DB)dataSource.getDbType()) : SqlOperations.build((DbIdentifiers.DB)DbIdentifiers.DB.HANA);
            this.sqlOperations.setDummySelectStatement(healthDummySelect);
        }
        catch (InternalError internalError) {
            throw new ParameterException((Throwable)internalError);
        }
    }

    @Deprecated
    public DbHealthIndicatorImpl(String healthDummySelect, TenantAwareDataSource dataSource, Long healthCheckIntervalMillis, HealthUp<T> healthUp, HealthDown<T> healthDown, HealthDownDetails<T> healthDownDetails, HealthUpDetails<T> healthUpDetails, boolean newCheck) {
        this(healthDummySelect, dataSource, healthCheckIntervalMillis, healthUp, healthDown, healthDownDetails, healthUpDetails);
    }

    @Deprecated
    public DbHealthIndicatorImpl(String healthDummySelect, TenantAwareDataSource dataSource, Long healthCheckIntervalMillis, HealthUp<T> healthUp, HealthDown<T> healthDown, HealthDownDetails<T> healthDownDetails) {
        this(healthDummySelect, dataSource, healthCheckIntervalMillis, healthUp, healthDown, healthDownDetails, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T health() {
        boolean hasLock = false;
        try {
            hasLock = this.lock.tryLock();
            if (!hasLock) {
                if (this.lastHealth == null) {
                    T t = this.healthUp.execute();
                    return t;
                }
                T t = this.lastHealth;
                return t;
            }
            ++this.callCounter;
            if (this.callCounter > 100) {
                this.callCounter = 0;
            }
            if (this.lastChecked != 0L && System.currentTimeMillis() - this.lastChecked < this.healthCheckIntervalMillis) {
                T t = this.lastHealth;
                return t;
            }
            try {
                ArrayList<String> detailInfo = new ArrayList<String>();
                boolean down = false;
                if (this.dataSource.getDataSourceLookup().hasDbIdentifiers()) {
                    down = this.isDownNewCheck(detailInfo);
                } else {
                    Map<String, List<DataSourceInfo>> infoPerDb = this.dataSourceInfoPerDb(this.dataSource.getDataSourceLookup().getCachedDataSource());
                    down = this.isDown(detailInfo, infoPerDb);
                }
                this.lastHealth = down ? this.healthDownDetails.execute("Detail information:", detailInfo) : (this.healthUpDetails != null ? this.healthUpDetails.execute("Detail information:", detailInfo) : this.healthUp.execute());
            }
            catch (RuntimeException e) {
                this.lastHealth = this.healthDown.execute();
            }
            this.lastChecked = System.currentTimeMillis();
            T t = this.lastHealth;
            return t;
        }
        finally {
            if (hasLock) {
                this.lock.unlock();
            }
        }
    }

    private boolean isDown(List<String> detailInfo, Map<String, List<DataSourceInfo>> uriToDbInfo) {
        Boolean[] downArray = new Boolean[]{false};
        uriToDbInfo.entrySet().forEach(infoListEntry -> {
            List infoList = (List)infoListEntry.getValue();
            for (DataSourceInfo info : infoList) {
                try {
                    this.dataSource.getDataSourceLookup().checkDataSource(info.getTenantId(), this.healthDummySelect);
                    detailInfo.add("Connection for DB " + info.getHost() + ":" + info.getPort() + " is ok");
                }
                catch (SQLException e) {
                    if (!this.dataSource.doesTenantExist(info.getTenantId())) continue;
                    logger.error("Could not open connection for DB {}", (Object)(info.getHost() + ":" + info.getPort()));
                    logger.debug("The following error was reported: {}", (Object)e.getMessage());
                    detailInfo.add("Could not open connection for DB " + info.getHost() + ":" + info.getPort());
                    downArray[0] = true;
                }
                break;
            }
        });
        return downArray[0];
    }

    private boolean isDownNewCheck(List<String> detailInfo) {
        List<HealtCheckResult> healthCheckResults = this.dataSource.getDataSourceLookup().checkDataSourcePerDb(this.healthDummySelect);
        Boolean[] down = new Boolean[]{false};
        healthCheckResults.stream().forEach(result -> {
            if (!result.isOk()) {
                logger.error("Could not open connection for DB {}", (Object)result.getDbIdentifier());
                if (this.callCounter == 100) {
                    logger.error("The following error was reported: ", (Throwable)result.getException());
                } else {
                    logger.error("The following error was reported: {}", (Object)result.getException().getMessage());
                }
                detailInfo.add("Could not open connection for DB " + result.getDbIdentifier() + ". Error is: " + result.getException().getMessage());
                down[0] = true;
            } else {
                logger.debug("Connection for DB {} is ok", (Object)result.getDbIdentifier());
                detailInfo.add("Connection for DB " + result.getDbIdentifier() + " is ok");
            }
        });
        return down[0];
    }

    public String getHealthDummySelect() {
        return this.healthDummySelect;
    }

    private Map<String, List<DataSourceInfo>> dataSourceInfoPerDb(List<DataSourceInfo> infoList) {
        HashMap<String, List<DataSourceInfo>> urlToInfo = new HashMap<String, List<DataSourceInfo>>();
        infoList.stream().forEach(i -> {
            ArrayList<DataSourceInfo> list = (ArrayList<DataSourceInfo>)urlToInfo.get(DbUtils.getDbKey(i));
            if (list == null) {
                list = new ArrayList<DataSourceInfo>();
                urlToInfo.put(DbUtils.getDbKey(i), list);
            }
            list.add((DataSourceInfo)i);
        });
        return urlToInfo;
    }

    @FunctionalInterface
    public static interface HealthUpDetails<T> {
        public T execute(String var1, List<String> var2);
    }

    @FunctionalInterface
    public static interface HealthDownDetails<T> {
        public T execute(String var1, List<String> var2);
    }

    @FunctionalInterface
    public static interface HealthDown<T> {
        public T execute();
    }

    @FunctionalInterface
    public static interface HealthUp<T> {
        public T execute();
    }
}

