/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.runtime;

import com.atomikos.jdbc.AtomikosDataSourceBean;
import com.sap.cloud.mt.runtime.DataPoolSettings;
import com.sap.cloud.mt.runtime.DataSourceCreatorAtomikos;
import com.sap.cloud.mt.runtime.DataSourceLookup;
import com.sap.cloud.mt.runtime.EnvironmentAccess;
import com.sap.cloud.mt.subscription.DataSourceInfo;
import com.sap.cloud.mt.subscription.InstanceLifecycleManager;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomikosDataSourceLookup
extends DataSourceLookup {
    private static Logger logger = LoggerFactory.getLogger(AtomikosDataSourceLookup.class);
    private final EnvironmentAccess environment;
    private final DataPoolSettings poolSettings;

    public AtomikosDataSourceLookup(InstanceLifecycleManager instanceLifecycleManager, EnvironmentAccess environment, DataPoolSettings poolSettings, boolean oneDataSourcePerDb) {
        super(instanceLifecycleManager, oneDataSourcePerDb);
        this.environment = environment;
        this.poolSettings = poolSettings;
    }

    @Override
    public DataSource create(DataSourceInfo info) throws InternalError {
        DataSourceCreatorAtomikos dataSourceCreator = null;
        logger.debug("Atomikos data source pool taken");
        dataSourceCreator = new DataSourceCreatorAtomikos(this.poolSettings);
        return dataSourceCreator.create(info, this.environment);
    }

    @Override
    public void closeDataSource(DataSource dataSource) {
        if (dataSource == null) {
            return;
        }
        logger.debug("Close Atomikos data source pool");
        AtomikosDataSourceBean atomikosDataSource = (AtomikosDataSourceBean)dataSource;
        atomikosDataSource.close();
    }
}

