/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.runtime;

import com.sap.cloud.mt.runtime.ConnectionProvider;
import com.sap.cloud.mt.runtime.ConnectionProviderFunction;
import com.sap.cloud.mt.runtime.DataSourceAndInfo;
import com.sap.cloud.mt.runtime.DataSourceLookup;
import com.sap.cloud.mt.runtime.TenantProvider;
import com.sap.cloud.mt.subscription.DataSourceInfo;
import com.sap.cloud.mt.subscription.DbIdentifiers;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.cloud.mt.subscription.exceptions.UnknownTenant;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantAwareDataSource
implements DataSource {
    private static final Logger logger = LoggerFactory.getLogger(TenantAwareDataSource.class);
    private final Supplier<String> tenantProvider;
    private final DataSourceLookup dataSourceLookup;
    private final BiFunction<String, Boolean, ConnectionProvider> connectionProviderFunction = new ConnectionProviderFunction();

    public TenantAwareDataSource(Supplier<String> tenantProvider, DataSourceLookup dataSourceLookup) {
        this.tenantProvider = tenantProvider;
        this.dataSourceLookup = dataSourceLookup;
        if (this.tenantProvider == null) {
            throw new IllegalArgumentException("No tenant provider set");
        }
        if (this.dataSourceLookup == null) {
            throw new IllegalArgumentException("No data source lookup object set");
        }
    }

    public TenantAwareDataSource(TenantProvider tenantProvider, DataSourceLookup dataSourceLookup) {
        this((Supplier<String>)tenantProvider, dataSourceLookup);
    }

    private DataSourceAndInfo getDataSourceAndInfo() throws InternalError, UnknownTenant {
        return this.dataSourceLookup.getDataSourceAndInfo(this.tenantProvider.get());
    }

    @Override
    public Connection getConnection() throws SQLException {
        ConnectionProvider connectionProvider = null;
        DataSourceAndInfo dsAndInfo = null;
        try {
            dsAndInfo = this.getDataSourceAndInfo();
        }
        catch (InternalError | UnknownTenant error) {
            throw new SQLException(error);
        }
        DataSourceInfo info = dsAndInfo.getDataSourceInfo();
        connectionProvider = this.connectionProviderFunction.apply(info.getDriver(), this.dataSourceLookup.isOneDataSourcePerDb());
        if (connectionProvider == null) {
            throw new SQLException("No connection provider determined for driver " + info.getDriver() + "and flag oneDataSourcePerDb=" + this.dataSourceLookup.isOneDataSourcePerDb());
        }
        try {
            return connectionProvider.getConnection(this.tenantProvider.get(), dsAndInfo);
        }
        catch (SQLException e) {
            logger.debug("Could not retrieve a connection => fix data source");
            try {
                if (!this.dataSourceLookup.fixDataSourceAfterCredentialChange(this.tenantProvider.get())) {
                    logger.error("Could not retrieve a connection because of error {}", (Object)e.getMessage());
                    throw e;
                }
                return connectionProvider.getConnection(this.tenantProvider.get(), this.getDataSourceAndInfo());
            }
            catch (InternalError | UnknownTenant | SQLException error) {
                throw new SQLException(error);
            }
        }
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new UnsupportedOperationException("getConnection with username and password isn't supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        try {
            DataSource dataSource = this.getDataSourceAndInfo().getDataSource();
            if (iface.isInstance(dataSource)) {
                return (T)dataSource;
            }
            return dataSource.unwrap(iface);
        }
        catch (InternalError | UnknownTenant | SQLException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        try {
            if (iface.isInstance(this)) {
                return true;
            }
            DataSource dataSource = this.getDataSourceAndInfo().getDataSource();
            return iface.isInstance(dataSource) || dataSource.isWrapperFor(iface);
        }
        catch (InternalError | UnknownTenant | SQLException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        logger.error("Operation getLogWriter is not supported");
        throw new UnsupportedOperationException("Operation getLogWriter is not supported");
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        logger.error("Operation setLogWriter is not supported");
        throw new UnsupportedOperationException("Operation setLogWriter is not supported");
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        logger.error("Operation setLoginTimeout is not supported");
        throw new UnsupportedOperationException("Operation setLoginTimeout is not supported");
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return java.util.logging.Logger.getLogger("global");
    }

    public void deleteFromCache(String tenantId) {
        this.dataSourceLookup.deleteFromCache(tenantId);
    }

    DataSourceLookup getDataSourceLookup() {
        return this.dataSourceLookup;
    }

    public Supplier<String> getTenantProvider() {
        return this.tenantProvider;
    }

    boolean doesTenantExist(String tenantId) {
        return this.dataSourceLookup.doesTenantExist(tenantId);
    }

    boolean fixDataSource(String tenantId) throws InternalError {
        return this.dataSourceLookup.fixDataSourceAfterCredentialChange(tenantId);
    }

    public DbIdentifiers.DB getDbType() {
        return this.dataSourceLookup.getDbType();
    }
}

