/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.runtime;

import com.sap.cloud.mt.runtime.DataPoolSettings;
import com.sap.cloud.mt.runtime.EnvironmentAccess;
import com.sap.cloud.mt.subscription.DataSourceInfo;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataSourceCreator {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceCreator.class);

    public final DataSource create(DataSourceInfo info, EnvironmentAccess env) throws InternalError {
        DataSource dataSource = this.build(info, env);
        this.setPoolParameters(dataSource, env);
        return dataSource;
    }

    private final void setPoolParameters(DataSource dataSource, EnvironmentAccess env) {
        this.getPoolParameters().forEach(p -> {
            Map<Object, Object> para = p.getType() != Properties.class ? env.getProperty(p.getNormalizedNameInEnv(), p.getType()) : env.getPropertiesForPrefix(p.getNormalizedNameInEnv());
            if (para != null) {
                try {
                    if (p.getType() != Properties.class) {
                        this.getMethod(dataSource, (DataPoolSettings.Parameter)p).invoke((Object)dataSource, para);
                    } else {
                        Properties properties = new Properties();
                        properties.putAll(para);
                        this.getMethod(dataSource, (DataPoolSettings.Parameter)p).invoke((Object)dataSource, properties);
                    }
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    protected abstract DataSource build(DataSourceInfo var1, EnvironmentAccess var2) throws InternalError;

    protected abstract Stream<DataPoolSettings.Parameter> getPoolParameters();

    private Method getMethod(DataSource dataSource, DataPoolSettings.Parameter p) throws NoSuchMethodException {
        try {
            return dataSource.getClass().getMethod(p.getSetterName(), p.getType());
        }
        catch (NoSuchMethodException e) {
            logger.debug("Try with another type");
            if (p.getType() == Boolean.TYPE) {
                return dataSource.getClass().getMethod(p.getSetterName(), Boolean.class);
            }
            if (p.getType() == Integer.TYPE) {
                return dataSource.getClass().getMethod(p.getSetterName(), Integer.class);
            }
            if (p.getType() == Long.TYPE) {
                return dataSource.getClass().getMethod(p.getSetterName(), Long.class);
            }
            throw new NoSuchMethodException();
        }
    }
}

