/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.runtime;

import com.sap.cloud.mt.runtime.DataPoolSettings;
import com.sap.cloud.mt.runtime.DataSourceCreatorTomcat;
import com.sap.cloud.mt.runtime.DataSourceLookup;
import com.sap.cloud.mt.runtime.EnvironmentAccess;
import com.sap.cloud.mt.subscription.DataSourceInfo;
import com.sap.cloud.mt.subscription.InstanceLifecycleManager;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatDataSourceLookup
extends DataSourceLookup {
    private static Logger logger = LoggerFactory.getLogger(TomcatDataSourceLookup.class);
    private final EnvironmentAccess environment;
    private final DataPoolSettings poolSettings;
    private final boolean registerJmx;

    public TomcatDataSourceLookup(InstanceLifecycleManager instanceLifecycleManager, EnvironmentAccess environment, DataPoolSettings poolSettings, boolean oneDataSourcePerDb, boolean registerJmx) {
        super(instanceLifecycleManager, oneDataSourcePerDb);
        this.environment = environment;
        this.poolSettings = poolSettings;
        this.registerJmx = registerJmx;
    }

    public TomcatDataSourceLookup(InstanceLifecycleManager instanceLifecycleManager, EnvironmentAccess environment, DataPoolSettings poolSettings, boolean oneDataSourcePerDb) {
        this(instanceLifecycleManager, environment, poolSettings, oneDataSourcePerDb, false);
    }

    @Override
    public javax.sql.DataSource create(DataSourceInfo info) throws InternalError {
        DataSourceCreatorTomcat dataSourceCreator = null;
        logger.debug("Tomcat pooling data source taken");
        dataSourceCreator = new DataSourceCreatorTomcat(this.poolSettings, this.registerJmx);
        return dataSourceCreator.create(info, this.environment);
    }

    @Override
    public void closeDataSource(javax.sql.DataSource dataSource) {
        if (dataSource == null) {
            return;
        }
        logger.debug("Close Tomcat pooling data source");
        DataSource tomcatDataSource = (DataSource)dataSource;
        tomcatDataSource.close();
    }
}

