/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.runtime;

import com.sap.cloud.mt.runtime.DbUtils;
import com.sap.cloud.mt.runtime.HealtCheckResult;
import com.sap.cloud.mt.runtime.TenantAwareDataSource;
import com.sap.cloud.mt.subscription.DataSourceInfo;
import com.sap.cloud.mt.subscription.DbIdentifiers;
import com.sap.cloud.mt.subscription.SqlOperations;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.cloud.mt.subscription.exceptions.ParameterException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbHealthIndicatorImpl<T> {
    private static final Logger logger = LoggerFactory.getLogger(DbHealthIndicatorImpl.class);
    private static final int STACK_TRACE_WRITE_PERIOD = 100;
    private static final String DETAIL_INFORMATION = "Detail information:";
    private final TenantAwareDataSource dataSource;
    private volatile long lastChecked = 0L;
    private AtomicReference<T> lastHealth = new AtomicReference<Object>(null);
    private final Long healthCheckIntervalMillis;
    private final HealthUp<T> healthUp;
    private final HealthDownDetails<T> healthDownDetails;
    private final HealthUpDetails<T> healthUpDetails;
    private AtomicInteger callCounter = new AtomicInteger(0);
    private final ReentrantLock lock = new ReentrantLock();
    private final SqlOperations sqlOperations;
    private final String healthDummySelect;

    public DbHealthIndicatorImpl(String healthDummySelect, TenantAwareDataSource dataSource, Long healthCheckIntervalMillis, HealthUp<T> healthUp, HealthDownDetails<T> healthDownDetails, HealthUpDetails<T> healthUpDetails) {
        this.healthDummySelect = healthDummySelect;
        this.dataSource = dataSource;
        this.healthCheckIntervalMillis = healthCheckIntervalMillis;
        this.healthUp = healthUp;
        this.healthDownDetails = healthDownDetails;
        this.healthUpDetails = healthUpDetails;
        try {
            this.sqlOperations = dataSource.getDbType() != null ? SqlOperations.build((DbIdentifiers.DB)dataSource.getDbType()) : SqlOperations.build((DbIdentifiers.DB)DbIdentifiers.DB.HANA);
            this.sqlOperations.setDummySelectStatement(healthDummySelect);
        }
        catch (InternalError internalError) {
            throw new ParameterException((Throwable)internalError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T health() {
        boolean hasLock = false;
        try {
            hasLock = this.lock.tryLock();
            if (!hasLock) {
                if (this.lastHealth.get() == null) {
                    logger.debug("Lock for health check couldn't be acquired. Return positive result as no last health check exists");
                    T t = this.healthUp.execute();
                    return t;
                }
                logger.debug("Return result of last health check as no lock could be acquired. Result was {}", (Object)this.lastHealth.get().toString());
                T t = this.lastHealth.get();
                return t;
            }
            this.callCounter.incrementAndGet();
            if (this.callCounter.get() > 100) {
                this.callCounter.set(0);
            }
            if (this.lastChecked != 0L && System.currentTimeMillis() - this.lastChecked < this.healthCheckIntervalMillis) {
                logger.debug("Result of last health check is returned as not much time has passed, result is {}", (Object)this.lastHealth.get().toString());
                T t = this.lastHealth.get();
                return t;
            }
            try {
                ArrayList<String> detailInfo = new ArrayList<String>();
                boolean down = false;
                down = this.dataSource.getDataSourceLookup().hasDbIdentifiers() ? this.isDownNewCheck(detailInfo) : this.isDown(detailInfo, this.getOneDataSourceInfoPerDb());
                if (down) {
                    this.lastHealth.set(this.healthDownDetails.execute(DETAIL_INFORMATION, detailInfo));
                } else {
                    this.lastHealth.set(this.healthUpDetails != null ? this.healthUpDetails.execute(DETAIL_INFORMATION, detailInfo) : this.healthUp.execute());
                }
            }
            catch (Exception e) {
                logger.error("Unexpected exception was thrown in health check", (Throwable)e);
                this.lastHealth.set(this.healthDownDetails.execute(DETAIL_INFORMATION, Arrays.asList(e.getMessage())));
            }
            this.lastChecked = System.currentTimeMillis();
            T t = this.lastHealth.get();
            return t;
        }
        finally {
            if (hasLock) {
                this.lock.unlock();
            }
        }
    }

    private Map<String, List<DataSourceInfo>> getOneDataSourceInfoPerDb() throws InternalError {
        List<DataSourceInfo> dataSourceInfos = this.dataSource.getDataSourceLookup().getCachedDataSource();
        if (dataSourceInfos.isEmpty()) {
            logger.debug("No datasource cached. Load one data source for health check");
            this.dataSource.getDataSourceLookup().loadOneTenantPerDb();
            dataSourceInfos = this.dataSource.getDataSourceLookup().getCachedDataSource();
            if (dataSourceInfos.isEmpty()) {
                logger.error("Could not determine a data source for health check");
            }
        }
        return this.dataSourceInfoPerDb(dataSourceInfos);
    }

    private boolean isDown(List<String> detailInfo, Map<String, List<DataSourceInfo>> uriToDbInfo) {
        logger.debug("Execute the old implementation of the health check.");
        if (uriToDbInfo.isEmpty()) {
            detailInfo.add("No DB schemas for test available");
            return false;
        }
        AtomicBoolean down = new AtomicBoolean(false);
        uriToDbInfo.entrySet().forEach(infoListEntry -> {
            try {
                this.checkOneDB(detailInfo, down, (Map.Entry<String, List<DataSourceInfo>>)infoListEntry);
            }
            catch (InternalError internalError) {
                detailInfo.add("Error occurred:" + internalError.getMessage());
                down.set(true);
            }
        });
        return down.get();
    }

    private void checkOneDB(List<String> detailInfo, AtomicBoolean down, Map.Entry<String, List<DataSourceInfo>> infoListEntry) throws InternalError {
        List<DataSourceInfo> infoList = infoListEntry.getValue();
        for (DataSourceInfo info : infoList) {
            try {
                this.dataSource.getDataSourceLookup().checkDataSource(info.getTenantId(), this.healthDummySelect);
                detailInfo.add("Connection for DB " + info.getHost() + ":" + info.getPort() + " is ok");
            }
            catch (SQLException e) {
                if (!this.dataSource.doesTenantExist(info.getTenantId())) continue;
                logger.error("Could not open connection for DB {}", (Object)(info.getHost() + ":" + info.getPort()));
                logger.debug("The following error was reported: {}", (Object)e.getMessage());
                detailInfo.add("Could not open connection for DB " + info.getHost() + ":" + info.getPort());
                down.set(true);
            }
            break;
        }
    }

    private boolean isDownNewCheck(List<String> detailInfo) {
        logger.debug("Execute the new implementation of the health check.");
        List<HealtCheckResult> healthCheckResults = this.dataSource.getDataSourceLookup().checkDataSourcePerDb(this.healthDummySelect);
        Boolean[] down = new Boolean[]{false};
        healthCheckResults.stream().forEach(result -> {
            if (!result.isOk()) {
                logger.error("Could not open connection for DB {}", (Object)result.getDbIdentifier());
                if (this.callCounter.get() == 100) {
                    logger.error("The following error was reported: ", (Throwable)result.getException());
                } else {
                    logger.error("The following error was reported: {}", (Object)result.getException().getMessage());
                }
                detailInfo.add("Could not open connection for DB " + result.getDbIdentifier() + ". Error is: " + result.getException().getMessage());
                down[0] = true;
            } else {
                logger.debug("Connection for DB {} is ok", (Object)result.getDbIdentifier());
                detailInfo.add("Connection for DB " + result.getDbIdentifier() + " is ok");
            }
        });
        return down[0];
    }

    public String getHealthDummySelect() {
        return this.healthDummySelect;
    }

    private Map<String, List<DataSourceInfo>> dataSourceInfoPerDb(List<DataSourceInfo> infoList) {
        HashMap<String, List<DataSourceInfo>> urlToInfo = new HashMap<String, List<DataSourceInfo>>();
        infoList.stream().forEach(i -> {
            ArrayList<DataSourceInfo> list = (ArrayList<DataSourceInfo>)urlToInfo.get(DbUtils.getDbKey(i));
            if (list == null) {
                list = new ArrayList<DataSourceInfo>();
                urlToInfo.put(DbUtils.getDbKey(i), list);
            }
            list.add((DataSourceInfo)i);
        });
        return urlToInfo;
    }

    @FunctionalInterface
    public static interface HealthUpDetails<T> {
        public T execute(String var1, List<String> var2);
    }

    @FunctionalInterface
    public static interface HealthDownDetails<T> {
        public T execute(String var1, List<String> var2);
    }

    @FunctionalInterface
    public static interface HealthDown<T> {
        public T execute();
    }

    @FunctionalInterface
    public static interface HealthUp<T> {
        public T execute();
    }
}

