/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.runtime;

import com.sap.cloud.mt.runtime.DataPoolSettings;
import com.sap.cloud.mt.runtime.DataSourceCreatorHikari;
import com.sap.cloud.mt.runtime.DataSourceLookup;
import com.sap.cloud.mt.runtime.EnvironmentAccess;
import com.sap.cloud.mt.subscription.DataSourceInfo;
import com.sap.cloud.mt.subscription.InstanceLifecycleManager;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import java.io.Closeable;
import java.io.IOException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HikariDataSourceLookup
extends DataSourceLookup {
    private static Logger logger = LoggerFactory.getLogger(HikariDataSourceLookup.class);
    private final EnvironmentAccess environment;
    private final DataPoolSettings poolSettings;

    public HikariDataSourceLookup(InstanceLifecycleManager instanceLifecycleManager, EnvironmentAccess environment, DataPoolSettings poolSettings, boolean oneDataSourcePerDb) {
        super(instanceLifecycleManager, oneDataSourcePerDb);
        this.environment = environment;
        this.poolSettings = poolSettings;
    }

    @Override
    public DataSource create(DataSourceInfo info) throws InternalError {
        DataSourceCreatorHikari dataSourceCreator = null;
        logger.debug("Hikari data source pool taken");
        dataSourceCreator = new DataSourceCreatorHikari(this.poolSettings);
        return dataSourceCreator.create(info, this.environment);
    }

    @Override
    public void closeDataSource(DataSource dataSource) {
        if (dataSource == null) {
            return;
        }
        logger.debug("Close Hikari data source pool");
        Closeable closeable = (Closeable)((Object)dataSource);
        try {
            closeable.close();
        }
        catch (IOException e) {
            logger.error("Could not close Hikari data source pool ", (Throwable)e);
        }
    }
}

