/******************************************************************************
 * © 2020 SAP SE or an SAP affiliate company. All rights reserved.            *
 ******************************************************************************/
package com.sap.cloud.mt.runtime;


import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.function.Supplier;

public class TenantProvider implements Supplier<String> {
    private static Logger logger = LoggerFactory.getLogger(TenantProvider.class);
    private final IdentityZoneDeterminer determiner;

    public TenantProvider(IdentityZoneDeterminer determiner) {
        this.determiner = determiner;
    }

    @Override
    public String get() {
        try {
            if (TenantOverwrite.isOverwritten()) {
                return TenantOverwrite.getTenantId();
            }
            return determiner.getIdentityZone();
        } catch (InternalError e) {
            logger.error("Could not determine tenant ID");
            throw new RuntimeException(e);
        }
    }
}

