/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.runtime;

import com.atomikos.jdbc.AtomikosDataSourceBean;
import com.sap.cloud.mt.runtime.DataPoolSettings;
import com.sap.cloud.mt.runtime.DataSourceCreator;
import com.sap.cloud.mt.runtime.EnvironmentAccess;
import com.sap.cloud.mt.subscription.DataSourceInfo;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.db.jdbcext.XADataSourceSAP;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.h2.jdbcx.JdbcDataSource;

public class DataSourceCreatorAtomikos
extends DataSourceCreator {
    private final DataPoolSettings poolSettings;

    public DataSourceCreatorAtomikos(DataPoolSettings poolSettings) {
        this.poolSettings = poolSettings;
    }

    @Override
    protected DataSource build(DataSourceInfo info, EnvironmentAccess env) throws InternalError {
        AtomikosDataSourceBean atomikosDataSourceBean = new AtomikosDataSourceBean();
        if (info.getDriver().equals("com.sap.db.jdbc.Driver")) {
            XADataSourceSAP xaDataSourceSAP = new XADataSourceSAP();
            xaDataSourceSAP.setUrl(info.getUrl());
            xaDataSourceSAP.setUser(info.getUser());
            xaDataSourceSAP.setPassword(info.getPassword());
            xaDataSourceSAP.setSchema(info.getSchema());
            if (info.getUrl().contains("?encrypt=true")) {
                xaDataSourceSAP.setConnectionProperty("encrypt", "true");
            }
            this.setDriverProperties(env, xaDataSourceSAP);
            atomikosDataSourceBean.setXaDataSource((XADataSource)xaDataSourceSAP);
        } else if (info.getDriver().equals("org.h2.Driver")) {
            JdbcDataSource xaDataSourceH2 = new JdbcDataSource();
            xaDataSourceH2.setUrl(info.getUrl());
            xaDataSourceH2.setUser(info.getUser());
            xaDataSourceH2.setPassword(info.getPassword());
            atomikosDataSourceBean.setXaDataSource((XADataSource)xaDataSourceH2);
        } else {
            throw new InternalError("Driver " + info.getDriver() + " is not supported");
        }
        atomikosDataSourceBean.setUniqueResourceName(info.getTenantId() + info.getSchema());
        return atomikosDataSourceBean;
    }

    private void setDriverProperties(EnvironmentAccess env, XADataSourceSAP xaDataSourceSAP) throws InternalError {
        Optional<DataPoolSettings.Parameter> parameter = this.poolSettings.getAtomikosParameters().findFirst();
        if (parameter.isPresent()) {
            String prefix = parameter.get().getPrefix();
            Map<Object, Object> driverPropertiesFromEnv = env.getPropertiesForPrefix(prefix + ".xa-properties");
            if (driverPropertiesFromEnv != null && !driverPropertiesFromEnv.isEmpty()) {
                Properties allDbProperties = xaDataSourceSAP.getProperties();
                if (allDbProperties == null) {
                    allDbProperties = new Properties();
                }
                allDbProperties.putAll(driverPropertiesFromEnv);
                xaDataSourceSAP.setProperties(allDbProperties);
            }
        } else {
            throw new InternalError("No prefix for atomikos parameters found");
        }
    }

    @Override
    protected Stream<DataPoolSettings.Parameter> getPoolParameters() {
        return this.poolSettings.getAtomikosParameters();
    }
}

