/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.runtime;

import com.sap.cloud.mt.runtime.DataPoolSettings;
import com.sap.cloud.mt.runtime.DataSourceCreator;
import com.sap.cloud.mt.subscription.DataSourceInfo;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.stream.Stream;
import javax.sql.DataSource;

public class DataSourceCreatorAtomikos
extends DataSourceCreator {
    private final DataPoolSettings poolSettings;

    public DataSourceCreatorAtomikos(DataPoolSettings poolSettings) {
        this.poolSettings = poolSettings;
    }

    @Override
    protected DataSource build(DataSourceInfo info) throws InternalError {
        try {
            Method setPasswordMethod;
            Method setUserMethod;
            Method setUrlMethod;
            Class<?> xaClazz;
            Object xaDataSource = null;
            if (info.getDriver().equals("com.sap.db.jdbc.Driver")) {
                xaClazz = Class.forName("com.sap.db.jdbcext.XADataSourceSAP");
                xaDataSource = xaClazz.newInstance();
                setUrlMethod = xaClazz.getMethod("setUrl", String.class);
                setUserMethod = xaClazz.getMethod("setUser", String.class);
                setPasswordMethod = xaClazz.getMethod("setPassword", String.class);
                Method setSchemaMethod = xaClazz.getMethod("setSchema", String.class);
                Method setConnectionProperty = xaClazz.getMethod("setConnectionProperty", String.class, String.class);
                setUrlMethod.invoke(xaDataSource, info.getUrl());
                setUserMethod.invoke(xaDataSource, info.getUser());
                setPasswordMethod.invoke(xaDataSource, info.getPassword());
                setSchemaMethod.invoke(xaDataSource, info.getSchema());
                if (info.getUrl().contains("?encrypt=true")) {
                    setConnectionProperty.invoke(xaDataSource, "encrypt", "true");
                }
            } else if (info.getDriver().equals("org.h2.Driver")) {
                xaClazz = Class.forName("org.h2.jdbcx.JdbcDataSource");
                xaDataSource = xaClazz.newInstance();
                setUrlMethod = xaClazz.getMethod("setUrl", String.class);
                setUserMethod = xaClazz.getMethod("setUser", String.class);
                setPasswordMethod = xaClazz.getMethod("setPassword", String.class);
                setUrlMethod.invoke(xaDataSource, info.getUrl());
                setUserMethod.invoke(xaDataSource, info.getUser());
                setPasswordMethod.invoke(xaDataSource, info.getPassword());
            } else {
                throw new InternalError("Driver " + info.getDriver() + " is not supported");
            }
            Class<?> atomikosClazz = Class.forName("com.atomikos.jdbc.AtomikosDataSourceBean");
            Object atomikosDataSourceBean = atomikosClazz.newInstance();
            Method setXaDataSourceMethod = atomikosClazz.getMethod("setXaDataSource", Class.forName("javax.sql.XADataSource"));
            Method setUniqueResourceNameMethod = atomikosClazz.getMethod("setUniqueResourceName", String.class);
            setXaDataSourceMethod.invoke(atomikosDataSourceBean, xaDataSource);
            setUniqueResourceNameMethod.invoke(atomikosDataSourceBean, info.getTenantId() + info.getSchema());
            return (DataSource)atomikosDataSourceBean;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Stream<DataPoolSettings.Parameter> getPoolParameters() {
        return this.poolSettings.getAtomikosParameters();
    }
}

