/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.runtime;

import com.sap.cloud.mt.runtime.DataPoolSettings;
import com.sap.cloud.mt.runtime.DataSourceCreator;
import com.sap.cloud.mt.subscription.DataSourceInfo;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.zaxxer.hikari.HikariDataSource;
import java.util.stream.Stream;
import javax.sql.DataSource;

public class DataSourceCreatorHikari
extends DataSourceCreator {
    private final DataPoolSettings poolSettings;

    public DataSourceCreatorHikari(DataPoolSettings poolSettings) {
        this.poolSettings = poolSettings;
    }

    @Override
    protected DataSource build(DataSourceInfo info) throws InternalError {
        HikariDataSource hikariDataSource = new HikariDataSource();
        hikariDataSource.setDriverClassName(info.getDriver());
        hikariDataSource.setJdbcUrl(info.getUrl());
        hikariDataSource.setUsername(info.getUser());
        hikariDataSource.setPassword(info.getPassword());
        return hikariDataSource;
    }

    @Override
    protected Stream<DataPoolSettings.Parameter> getPoolParameters() {
        return this.poolSettings.getHikariParameters();
    }
}

