/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.runtime;

import com.sap.cloud.mt.runtime.DataPoolSettings;
import com.sap.cloud.mt.runtime.DataSourceCreator;
import com.sap.cloud.mt.subscription.DataSourceInfo;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import java.lang.management.ManagementFactory;
import java.util.stream.Stream;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceCreatorTomcat
extends DataSourceCreator {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceCreatorTomcat.class);
    private final DataPoolSettings poolSettings;
    private final boolean registerJmx;

    public DataSourceCreatorTomcat(DataPoolSettings poolSettings, boolean registerJmx) {
        this.poolSettings = poolSettings;
        this.registerJmx = registerJmx;
    }

    @Override
    protected javax.sql.DataSource build(DataSourceInfo info) throws InternalError {
        DataSource dataSource = new DataSource();
        dataSource.setDriverClassName(info.getDriver());
        dataSource.setUrl(info.getUrl());
        dataSource.setUsername(info.getUser());
        dataSource.setPassword(info.getPassword());
        if (this.registerJmx) {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            try {
                dataSource.createPool();
                ObjectName objectName = new ObjectName("tomcat.jdbc:type=ConnectionPool,class=org.apache.tomcat.jdbc.pool.DataSource,name=" + info.getTenantId());
                dataSource.preRegister(server, objectName);
            }
            catch (Exception e) {
                logger.error("Could not register JMX. Error is", (Throwable)e);
            }
        }
        return dataSource;
    }

    @Override
    protected Stream<DataPoolSettings.Parameter> getPoolParameters() {
        return this.poolSettings.getTomcatParameters();
    }
}

