/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.runtime;

import com.sap.cloud.mt.runtime.DataSourceAndInfo;
import com.sap.cloud.mt.runtime.DbUtils;
import com.sap.cloud.mt.runtime.HealtCheckResult;
import com.sap.cloud.mt.subscription.DataSourceInfo;
import com.sap.cloud.mt.subscription.InstanceLifecycleManager;
import com.sap.cloud.mt.subscription.TenantMutex;
import com.sap.cloud.mt.subscription.TenantMutexFactory;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.cloud.mt.subscription.exceptions.UnknownTenant;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataSourceLookup {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceLookup.class);
    private static final String HANA_DUMMY_SELECT = "select 1 as a from dummy";
    private final ConcurrentHashMap<String, DataSourceAndInfo> tenantToDataSource = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, DataSource> dbKeyToDataSource = new ConcurrentHashMap();
    private final InstanceLifecycleManager instanceLifecycleManager;
    private boolean oneDataSourcePerDb = false;

    public DataSourceLookup(InstanceLifecycleManager instanceLifecycleManager, boolean oneDataSourcePerDb) {
        this.instanceLifecycleManager = instanceLifecycleManager;
        this.oneDataSourcePerDb = oneDataSourcePerDb;
    }

    public DataSourceLookup(InstanceLifecycleManager instanceLifecycleManager) {
        this(instanceLifecycleManager, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataSourceAndInfo getDataSourceAndInfo(String tenantId) throws InternalError, UnknownTenant {
        DataSourceAndInfo dataSourceAndInfo = this.tenantToDataSource.get(tenantId);
        if (dataSourceAndInfo != null) {
            return dataSourceAndInfo;
        }
        TenantMutex tenantMutex = TenantMutexFactory.get((String)tenantId);
        synchronized (tenantMutex) {
            dataSourceAndInfo = this.tenantToDataSource.get(tenantId);
            if (dataSourceAndInfo != null) {
                return dataSourceAndInfo;
            }
            logger.debug("Access instance manager for tenant {}", (Object)tenantId);
            DataSourceInfo info = this.instanceLifecycleManager.getDataSourceInfo(tenantId, true);
            String dbKey = DbUtils.getDbKey(info);
            DataSource dataSource = null;
            if (this.oneDataSourcePerDb) {
                dataSource = this.dbKeyToDataSource.get(dbKey);
                if (dataSource == null) {
                    this.preparePools();
                    dataSource = this.dbKeyToDataSource.get(dbKey);
                    if (dataSource == null) {
                        throw new InternalError("Could not find database pool for db key " + dbKey);
                    }
                }
            } else {
                this.preparePools();
                dataSource = this.create(info);
            }
            DataSourceAndInfo newEntry = new DataSourceAndInfo(dataSource, info);
            this.tenantToDataSource.put(tenantId, newEntry);
            return newEntry;
        }
    }

    private void preparePools() throws InternalError {
        this.preparePools(false);
    }

    private void preparePools(boolean force) throws InternalError {
        if (!force && this.dbKeyToDataSource.size() > 0) {
            return;
        }
        List libContainers = this.instanceLifecycleManager.createAndGetLibContainers();
        libContainers.stream().forEach(info -> {
            String dbKey = DbUtils.getDbKey(info);
            if (!this.dbKeyToDataSource.containsKey(dbKey)) {
                try {
                    DataSource dataSource = this.create((DataSourceInfo)info);
                    this.dbKeyToDataSource.put(dbKey, dataSource);
                }
                catch (InternalError internalError) {
                    logger.error("Cannot create data source pool for tenant {}", (Object)info.getTenantId());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fixDataSourceAfterCredentialChange(String tenantId) throws InternalError, UnknownTenant {
        if (tenantId == null || tenantId.isEmpty()) {
            return;
        }
        TenantMutex tenantMutex = TenantMutexFactory.get((String)tenantId);
        synchronized (tenantMutex) {
            if (!this.oneDataSourcePerDb) {
                DataSourceAndInfo dataSourceAndInfo = this.tenantToDataSource.get(tenantId);
                if (dataSourceAndInfo == null) {
                    return;
                }
                DataSourceInfo cachedInfo = dataSourceAndInfo.getDataSourceInfo();
                DataSourceInfo currentInfo = this.instanceLifecycleManager.getDataSourceInfo(tenantId, true);
                if (!(currentInfo != null && currentInfo.getPassword().equals(cachedInfo.getPassword()) && currentInfo.getUser().equals(cachedInfo.getUser()) && currentInfo.getSchema().equals(cachedInfo.getSchema()) && currentInfo.getHost().equals(cachedInfo.getHost()) && currentInfo.getPort().equals(cachedInfo.getPort()))) {
                    this.deleteFromCache(tenantId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteFromCache(String tenantId) {
        if (tenantId == null) {
            return;
        }
        logger.debug("Instance for tenant {} deleted from cache", (Object)tenantId);
        TenantMutex tenantMutex = TenantMutexFactory.get((String)tenantId);
        synchronized (tenantMutex) {
            DataSourceAndInfo dataSourceAndInfo = this.tenantToDataSource.get(tenantId);
            if (dataSourceAndInfo == null) {
                return;
            }
            this.tenantToDataSource.remove(tenantId);
            if (this.oneDataSourcePerDb) {
                long numberOfEntries = this.tenantToDataSource.entrySet().stream().filter(e -> ((DataSourceAndInfo)e.getValue()).getDataSource() == dataSourceAndInfo.getDataSource()).count();
                if (numberOfEntries == 0L) {
                    this.dbKeyToDataSource.remove(DbUtils.getDbKey(dataSourceAndInfo.getDataSourceInfo()));
                    this.closeDataSource(dataSourceAndInfo.getDataSource());
                }
            } else {
                this.closeDataSource(dataSourceAndInfo.getDataSource());
            }
        }
    }

    public void reset() {
        if (this.oneDataSourcePerDb) {
            this.tenantToDataSource.clear();
            this.dbKeyToDataSource.entrySet().stream().forEach(e -> this.closeDataSource((DataSource)e.getValue()));
            this.dbKeyToDataSource.clear();
        } else {
            this.tenantToDataSource.entrySet().stream().forEach(e -> this.closeDataSource(((DataSourceAndInfo)e.getValue()).getDataSource()));
            this.tenantToDataSource.clear();
        }
    }

    public List<DataSourceInfo> getCachedDataSource() {
        ArrayList<DataSourceInfo> result = new ArrayList<DataSourceInfo>();
        this.tenantToDataSource.entrySet().stream().forEach(e -> result.add(((DataSourceAndInfo)e.getValue()).getDataSourceInfo().clone()));
        return result;
    }

    public List<HealtCheckResult> checkDataSourcePerDb(String dummySelectStatement) {
        ArrayList<HealtCheckResult> result = new ArrayList<HealtCheckResult>();
        try {
            this.preparePools();
        }
        catch (InternalError internalError) {
            HealtCheckResult healtCheckResult = new HealtCheckResult("", false, (Exception)((Object)internalError));
            result.add(healtCheckResult);
            return result;
        }
        this.dbKeyToDataSource.entrySet().stream().forEach(e -> {
            try (Connection connection = ((DataSource)e.getValue()).getConnection();
                 Statement statement = connection.createStatement();){
                if (dummySelectStatement != null && !dummySelectStatement.isEmpty()) {
                    statement.execute(dummySelectStatement);
                } else {
                    statement.execute(HANA_DUMMY_SELECT);
                }
                HealtCheckResult healtCheckResult = new HealtCheckResult((String)e.getKey(), true, null);
                result.add(healtCheckResult);
            }
            catch (SQLException exception) {
                HealtCheckResult healtCheckResult = new HealtCheckResult((String)e.getKey(), false, exception);
                result.add(healtCheckResult);
            }
        });
        return result;
    }

    protected abstract DataSource create(DataSourceInfo var1) throws InternalError;

    protected abstract void closeDataSource(DataSource var1);

    public boolean isOneDataSourcePerDb() {
        return this.oneDataSourcePerDb;
    }
}

