/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.runtime;

import com.sap.cloud.mt.runtime.ConnectionChecker;
import com.sap.cloud.mt.runtime.DbUtils;
import com.sap.cloud.mt.runtime.HealtCheckResult;
import com.sap.cloud.mt.runtime.TenantAwareDataSource;
import com.sap.cloud.mt.subscription.DataSourceInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbHealthIndicatorImpl<T> {
    private static final Logger logger = LoggerFactory.getLogger(DbHealthIndicatorImpl.class);
    private static final int STACK_TRACE_WRITE_PERIOD = 100;
    private final String healthDummySelect;
    private final TenantAwareDataSource dataSource;
    private final ConnectionChecker connectionChecker;
    private long lastChecked = 0L;
    private T lastHealth = null;
    private final Long healthCheckIntervalMillis;
    private final HealthUp<T> healthUp;
    private final HealthDown<T> healthDown;
    private final HealthDownDetails<T> healthDownDetails;
    private final HealthUpDetails<T> healthUpDetails;
    private final boolean newCheck;
    private int callCounter = 0;

    public DbHealthIndicatorImpl(String healthDummySelect, TenantAwareDataSource dataSource, Long healthCheckIntervalMillis, HealthUp<T> healthUp, HealthDown<T> healthDown, HealthDownDetails<T> healthDownDetails, HealthUpDetails<T> healthUpDetails, boolean newCheck) {
        this.healthDummySelect = healthDummySelect;
        this.dataSource = dataSource;
        this.connectionChecker = new ConnectionChecker();
        this.healthCheckIntervalMillis = healthCheckIntervalMillis;
        this.healthUp = healthUp;
        this.healthDown = healthDown;
        this.healthDownDetails = healthDownDetails;
        this.healthUpDetails = healthUpDetails;
        this.newCheck = newCheck;
    }

    public DbHealthIndicatorImpl(String healthDummySelect, TenantAwareDataSource dataSource, Long healthCheckIntervalMillis, HealthUp<T> healthUp, HealthDown<T> healthDown, HealthDownDetails<T> healthDownDetails) {
        this(healthDummySelect, dataSource, healthCheckIntervalMillis, healthUp, healthDown, healthDownDetails, null, false);
    }

    public synchronized T health() {
        ++this.callCounter;
        if (this.callCounter > 100) {
            this.callCounter = 0;
        }
        long currentTime = System.currentTimeMillis();
        if (this.lastChecked != 0L && currentTime - this.lastChecked < this.healthCheckIntervalMillis) {
            return this.lastHealth;
        }
        this.lastChecked = currentTime;
        try {
            ArrayList<String> detailInfo = new ArrayList<String>();
            boolean down = false;
            if (this.newCheck) {
                down = this.isDownNewCheck(detailInfo);
            } else {
                List<DataSourceInfo> oneInfoPerDb = this.filterOneInfoPerDB(this.dataSource.getDataSourceLookup().getCachedDataSource());
                down = this.isDown(detailInfo, oneInfoPerDb);
            }
            if (down) {
                this.lastHealth = this.healthDownDetails.execute("Detail information:", detailInfo);
                return this.lastHealth;
            }
            this.lastHealth = this.healthUpDetails != null ? this.healthUpDetails.execute("Detail information:", detailInfo) : this.healthUp.execute();
            return this.lastHealth;
        }
        catch (RuntimeException e) {
            this.lastHealth = this.healthDown.execute();
            return this.lastHealth;
        }
    }

    private boolean isDown(List<String> detailInfo, List<DataSourceInfo> oneInfoPerDb) {
        Boolean[] downArray = new Boolean[]{false};
        oneInfoPerDb.stream().forEach(info -> {
            if (info.getTenantId() != null && !info.getTenantId().trim().isEmpty()) {
                try {
                    this.connectionChecker.checkConnection(info.getTenantId(), this.dataSource, this.healthDummySelect);
                    detailInfo.add("Connection for DB " + info.getHost() + ":" + info.getPort() + " is ok");
                }
                catch (SQLException e) {
                    logger.error("Could not open connection for DB {}", (Object)(info.getHost() + ":" + info.getPort()));
                    logger.debug("The following error was reported: {}", (Object)e.getMessage());
                    detailInfo.add("Could not open connection for DB " + info.getHost() + ":" + info.getPort());
                    downArray[0] = true;
                }
            }
        });
        return downArray[0];
    }

    private boolean isDownNewCheck(List<String> detailInfo) {
        List<HealtCheckResult> healthCheckResults = this.dataSource.getDataSourceLookup().checkDataSourcePerDb(this.healthDummySelect);
        Boolean[] down = new Boolean[]{false};
        healthCheckResults.stream().forEach(result -> {
            if (!result.isOk()) {
                logger.error("Could not open connection for DB {}", (Object)result.getDbIdentifier());
                if (this.callCounter == 100) {
                    logger.error("The following error was reported: ", (Throwable)result.getException());
                } else {
                    logger.error("The following error was reported: {}", (Object)result.getException().getMessage());
                }
                detailInfo.add("Could not open connection for DB " + result.getDbIdentifier() + ". Error is: " + result.getException().getMessage());
                down[0] = true;
            } else {
                logger.debug("Connection for DB {} is ok", (Object)result.getDbIdentifier());
                detailInfo.add("Connection for DB " + result.getDbIdentifier() + " is ok");
            }
        });
        return down[0];
    }

    public String getHealthDummySelect() {
        return this.healthDummySelect;
    }

    private List<DataSourceInfo> filterOneInfoPerDB(List<DataSourceInfo> infoList) {
        HashMap urlToInfo = new HashMap();
        infoList.stream().forEach(i -> {
            ArrayList<DataSourceInfo> list = (ArrayList<DataSourceInfo>)urlToInfo.get(DbUtils.getDbKey(i));
            if (list == null) {
                list = new ArrayList<DataSourceInfo>();
                urlToInfo.put(DbUtils.getDbKey(i), list);
            }
            list.add((DataSourceInfo)i);
        });
        urlToInfo.entrySet().stream().forEach(e -> ((List)e.getValue()).sort(new Comparator<DataSourceInfo>(){

            @Override
            public int compare(DataSourceInfo o1, DataSourceInfo o2) {
                return o1.getTenantId().compareTo(o2.getTenantId());
            }
        }));
        ArrayList<DataSourceInfo> filteredList = new ArrayList<DataSourceInfo>();
        urlToInfo.entrySet().stream().forEach(e -> filteredList.add((DataSourceInfo)((List)e.getValue()).get(0)));
        return filteredList;
    }

    @FunctionalInterface
    public static interface HealthUpDetails<T> {
        public T execute(String var1, List<String> var2);
    }

    @FunctionalInterface
    public static interface HealthDownDetails<T> {
        public T execute(String var1, List<String> var2);
    }

    @FunctionalInterface
    public static interface HealthDown<T> {
        public T execute();
    }

    @FunctionalInterface
    public static interface HealthUp<T> {
        public T execute();
    }
}

