/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.runtime;

public class TenantOverwrite
implements AutoCloseable {
    private static final ThreadLocal<TenantAndCount> overwritePerThread = new ThreadLocal();

    public TenantOverwrite(String tenantId) {
        TenantAndCount tenantAndCount = overwritePerThread.get();
        if (tenantAndCount != null) {
            if (!tenantAndCount.getTenantId().equals(tenantId)) {
                throw new UnsupportedOperationException("It is not supported to stack overwrites with different tenants");
            }
        } else {
            tenantAndCount = new TenantAndCount(tenantId);
            overwritePerThread.set(tenantAndCount);
        }
        tenantAndCount.inc();
    }

    public static boolean isOverwritten() {
        return overwritePerThread.get() != null;
    }

    public static String getTenantId() {
        return overwritePerThread.get() != null ? overwritePerThread.get().getTenantId() : null;
    }

    @Override
    public void close() {
        if (overwritePerThread.get() != null) {
            overwritePerThread.get().dec();
            if (overwritePerThread.get().counterIsZero()) {
                overwritePerThread.remove();
            }
        }
    }

    private static class TenantAndCount {
        private String tenantId;
        private int callDepth = 0;

        public TenantAndCount(String tenantId) {
            this.tenantId = tenantId;
        }

        public void inc() {
            ++this.callDepth;
        }

        public void dec() {
            --this.callDepth;
        }

        public boolean counterIsZero() {
            return this.callDepth == 0;
        }

        public String getTenantId() {
            return this.tenantId;
        }
    }
}

