/******************************************************************************
 * © 2020 SAP SE or an SAP affiliate company. All rights reserved.            *
 ******************************************************************************/

package com.sap.cloud.mt.runtime;

import com.sap.cloud.mt.subscription.InstanceLifecycleManager;

import java.util.Locale;

public class DataSourceLookupFactory {

    public static final String TOMCAT = "tomcat";
    public static final String HIKARI = "hikari";
    public static final String ATOMIKOS = "atomikos";

    public static DataSourceLookup createDataSourceLookup(InstanceLifecycleManager instanceLifecycleManager, EnvironmentAccess environmentAccess,
                                                          DataPoolSettings dataPoolSettings, String poolProvider,
                                                          boolean oneDataSourcePerDb, boolean registerJmx) {
        if (poolProvider == null || poolProvider.isEmpty()) {
            poolProvider = HIKARI;
        }
        switch (poolProvider.toLowerCase(Locale.ENGLISH)) {
            case TOMCAT:
                return new TomcatDataSourceLookup(instanceLifecycleManager, environmentAccess, dataPoolSettings,
                        oneDataSourcePerDb, registerJmx);
            case HIKARI:
                return new HikariDataSourceLookup(instanceLifecycleManager, environmentAccess, dataPoolSettings,
                        oneDataSourcePerDb);
            case ATOMIKOS:
                return new AtomikosDataSourceLookup(instanceLifecycleManager, environmentAccess, dataPoolSettings,
                        oneDataSourcePerDb);
            default:
                throw new IllegalArgumentException("Pool provider " + poolProvider + " is not supported");
        }
    }

    @Deprecated
    public static DataSourceLookup createDataSourceLookup(InstanceLifecycleManager instanceLifecycleManager, EnvironmentAccess environmentAccess,
                                                          DataPoolSettings dataPoolSettings, String poolProvider,
                                                          boolean oneDataSourcePerDb) {
        return createDataSourceLookup(instanceLifecycleManager, environmentAccess, dataPoolSettings, poolProvider,
                oneDataSourcePerDb, false);
    }
}
