/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.runtime;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class DataPoolSettings {
    private final Map<ConnectionPoolType, ParameterList> parameterLists = new EnumMap<ConnectionPoolType, ParameterList>(ConnectionPoolType.class);

    public DataPoolSettings(String hikariPrefix, String tomcatPrefix, String atomikosPrefix) {
        this(DataPoolSettings.createLegacyConfig(hikariPrefix, tomcatPrefix, atomikosPrefix));
    }

    private static Map<String, ConnectionPoolType> createLegacyConfig(String hikariPrefix, String tomcatPrefix, String atomikosPrefix) {
        HashMap<String, ConnectionPoolType> config = new HashMap<String, ConnectionPoolType>();
        config.put(hikariPrefix, ConnectionPoolType.HIKARI);
        config.put(tomcatPrefix, ConnectionPoolType.TOMCAT);
        return config;
    }

    public DataPoolSettings(Map<String, ConnectionPoolType> prefixToPoolType) {
        for (ConnectionPoolType type : ConnectionPoolType.values()) {
            this.parameterLists.put(type, type.createParameterList());
        }
        for (Map.Entry entry : prefixToPoolType.entrySet()) {
            String prefix = (String)entry.getKey();
            this.parameterLists.get(entry.getValue()).initList(prefix);
        }
    }

    public Stream<Parameter> getHikariParameters() {
        return this.parameterLists.get((Object)ConnectionPoolType.HIKARI).stream();
    }

    public Stream<Parameter> getTomcatParameters() {
        return this.parameterLists.get((Object)ConnectionPoolType.TOMCAT).stream();
    }

    public static String normalizedName(String name) {
        if (name == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char current = name.charAt(i);
            if (Character.isUpperCase(current)) {
                if (i != 0) {
                    stringBuilder.append("-");
                }
                stringBuilder.append(Character.toLowerCase(current));
                continue;
            }
            stringBuilder.append(current);
        }
        return stringBuilder.toString();
    }

    public static enum ConnectionPoolType {
        HIKARI(HikariParameterList::new),
        TOMCAT(TomcatParameterList::new);

        private final Supplier<ParameterList> paramListSupplier;

        private ConnectionPoolType(Supplier<ParameterList> paramListSupplier) {
            this.paramListSupplier = paramListSupplier;
        }

        ParameterList createParameterList() {
            return this.paramListSupplier.get();
        }
    }

    public static interface ParameterList
    extends List<Parameter> {
        public void initList(String var1);
    }

    private static class TomcatParameterList
    extends LinkedList<Parameter>
    implements ParameterList {
        private TomcatParameterList() {
        }

        @Override
        public void initList(String prefix) {
            this.add(new Parameter("initialSize", Integer.TYPE, prefix));
            this.add(new Parameter("maxWait", Integer.TYPE, prefix));
            this.add(new Parameter("maxActive", Integer.TYPE, prefix));
            this.add(new Parameter("maxIdle", Integer.TYPE, prefix));
            this.add(new Parameter("minIdle", Integer.TYPE, prefix));
            this.add(new Parameter("defaultAutoCommit", Boolean.TYPE, prefix));
            this.add(new Parameter("testOnBorrow", Boolean.TYPE, prefix));
            this.add(new Parameter("validationInterval", Long.TYPE, prefix));
            this.add(new Parameter("validationQueryTimeout", Integer.TYPE, prefix));
            this.add(new Parameter("validationQuery", String.class, prefix));
            this.add(new Parameter("defaultReadOnly", Boolean.TYPE, prefix));
            this.add(new Parameter("testOnConnect", Boolean.TYPE, prefix));
            this.add(new Parameter("testOnReturn", Boolean.TYPE, prefix));
            this.add(new Parameter("testWhileIdle", Boolean.TYPE, prefix));
            this.add(new Parameter("timeBetweenEvictionRunsMillis", Integer.TYPE, prefix));
            this.add(new Parameter("minEvictableIdleTimeMillis", Integer.TYPE, prefix));
            this.add(new Parameter("removeAbandoned", Boolean.TYPE, prefix));
            this.add(new Parameter("removeAbandonedTimeout", Integer.TYPE, prefix));
            this.add(new Parameter("logAbandoned", Boolean.TYPE, prefix));
            this.add(new Parameter("initSQL", String.class, prefix));
            this.add(new Parameter("jdbcInterceptors", String.class, prefix));
            this.add(new Parameter("jmxEnabled", Boolean.TYPE, prefix));
            this.add(new Parameter("fairQueue", Boolean.TYPE, prefix));
            this.add(new Parameter("abandonWhenPercentageFull", Integer.TYPE, prefix));
            this.add(new Parameter("maxAge", Long.TYPE, prefix));
            this.add(new Parameter("useEquals", Boolean.TYPE, prefix));
            this.add(new Parameter("suspectTimeout", Integer.TYPE, prefix));
            this.add(new Parameter("rollbackOnReturn", Boolean.TYPE, prefix));
            this.add(new Parameter("commitOnReturn", Boolean.TYPE, prefix));
            this.add(new Parameter("useDisposableConnectionFacade", Boolean.TYPE, prefix));
            this.add(new Parameter("logValidationErrors", Boolean.TYPE, prefix));
            this.add(new Parameter("propagateInterruptState", Boolean.TYPE, prefix));
            this.add(new Parameter("ignoreExceptionOnPreLoad", Boolean.TYPE, prefix));
            this.add(new Parameter("useStatementFacade", Boolean.TYPE, prefix));
            this.add(new Parameter("dbProperties", Properties.class, prefix));
        }
    }

    private static class HikariParameterList
    extends LinkedList<Parameter>
    implements ParameterList {
        private HikariParameterList() {
        }

        @Override
        public void initList(String prefix) {
            this.add(new Parameter("autoCommit", Boolean.TYPE, prefix));
            this.add(new Parameter("connectionTimeout", Long.TYPE, prefix));
            this.add(new Parameter("idleTimeout", Long.TYPE, prefix));
            this.add(new Parameter("maxLifetime", Long.TYPE, prefix));
            this.add(new Parameter("minimumIdle", Integer.TYPE, prefix));
            this.add(new Parameter("maximumPoolSize", Integer.TYPE, prefix));
            this.add(new Parameter("initializationFailTimeout", Long.TYPE, prefix));
            this.add(new Parameter("isolateInternalQueries", Boolean.TYPE, prefix));
            this.add(new Parameter("allowPoolSuspension", Boolean.TYPE, prefix));
            this.add(new Parameter("readOnly", Boolean.TYPE, prefix));
            this.add(new Parameter("registerMbeans", Boolean.TYPE, prefix));
            this.add(new Parameter("catalog", String.class, prefix));
            this.add(new Parameter("connectionInitSql", String.class, prefix));
            this.add(new Parameter("transactionIsolation", String.class, prefix));
            this.add(new Parameter("validationTimeout", Long.TYPE, prefix));
            this.add(new Parameter("leakDetectionThreshold", Long.TYPE, prefix));
            this.add(new Parameter("connectionTestQuery", String.class, prefix));
            this.add(new Parameter("dataSourceProperties", Properties.class, prefix));
        }
    }

    public static class Parameter {
        private final String name;
        private final Class<?> type;
        private final String prefix;

        private Parameter(String name, Class<?> type, String prefix) {
            this.name = name;
            this.type = type;
            this.prefix = prefix;
        }

        public String getNameInEnv() {
            return this.prefix + "." + this.name;
        }

        public String getNormalizedNameInEnv() {
            return this.prefix + "." + DataPoolSettings.normalizedName(this.name);
        }

        public String getPoolPropertyName() {
            return this.name;
        }

        public Class<?> getType() {
            return this.type;
        }

        public String getSetterName() {
            return "set" + this.name.substring(0, 1).toUpperCase(Locale.ENGLISH) + this.name.substring(1);
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

