/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.runtime;

import com.sap.cloud.mt.runtime.DataPoolSettings;
import com.sap.cloud.mt.runtime.DataSourceLookup;
import com.sap.cloud.mt.runtime.EnvironmentAccess;
import com.sap.cloud.mt.runtime.HikariDataSourceLookup;
import com.sap.cloud.mt.runtime.TomcatDataSourceLookup;
import com.sap.cloud.mt.subscription.InstanceLifecycleManager;
import java.util.Locale;
import java.util.Map;

public class DataSourceLookupBuilder {
    private static final String TOMCAT = "tomcat";
    private static final String HIKARI = "hikari";
    private InstanceLifecycleManager instanceLifecycleManager;
    private EnvironmentAccess environmentAccess;
    private String poolProvider;
    private boolean oneDataSourcePerDb;
    private boolean registerJmx;
    private Map<String, DataPoolSettings.ConnectionPoolType> prefixToPoolType;

    private DataSourceLookupBuilder() {
    }

    public static DataSourceLookupBuilder create() {
        return new DataSourceLookupBuilder();
    }

    public DataSourceLookup build() {
        DataPoolSettings dataPoolSettings = this.prefixToPoolType != null && !this.prefixToPoolType.isEmpty() ? new DataPoolSettings(this.prefixToPoolType) : new DataPoolSettings("spring.datasource.hikari", "spring.datasource.tomcat", "com.sap.mt.atomikos");
        if (this.poolProvider == null || this.poolProvider.isEmpty()) {
            this.poolProvider = HIKARI;
        }
        switch (this.poolProvider.toLowerCase(Locale.ENGLISH)) {
            case "tomcat": {
                return new TomcatDataSourceLookup(this.instanceLifecycleManager, this.environmentAccess, dataPoolSettings, this.oneDataSourcePerDb, this.registerJmx);
            }
            case "hikari": {
                return new HikariDataSourceLookup(this.instanceLifecycleManager, this.environmentAccess, dataPoolSettings, this.oneDataSourcePerDb);
            }
        }
        throw new IllegalArgumentException("Pool provider " + this.poolProvider + " is not supported");
    }

    public DataSourceLookupBuilder instanceLifecycleManager(InstanceLifecycleManager instanceLifecycleManager) {
        this.instanceLifecycleManager = instanceLifecycleManager;
        return this;
    }

    public DataSourceLookupBuilder environmentAccess(EnvironmentAccess environmentAccess) {
        this.environmentAccess = environmentAccess;
        return this;
    }

    public DataSourceLookupBuilder poolProvider(String poolProvider) {
        this.poolProvider = poolProvider;
        return this;
    }

    public DataSourceLookupBuilder oneDataSourcePerDb(boolean oneDataSourcePerDb) {
        this.oneDataSourcePerDb = oneDataSourcePerDb;
        return this;
    }

    public DataSourceLookupBuilder registerJmx(boolean registerJmx) {
        this.registerJmx = registerJmx;
        return this;
    }

    public DataSourceLookupBuilder prefixToPoolType(Map<String, DataPoolSettings.ConnectionPoolType> prefixToPoolType) {
        this.prefixToPoolType = prefixToPoolType;
        return this;
    }
}

