/******************************************************************************
 * © 2020 SAP SE or an SAP affiliate company. All rights reserved.            *
 ******************************************************************************/

package com.sap.cloud.mt.runtime;

import com.sap.cloud.mt.subscription.DataSourceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class HanaConnectionProvider implements ConnectionProvider {
    private static Logger logger = LoggerFactory.getLogger(HanaConnectionProvider.class);

    @Override
    public Connection getConnection(String tenantId, DataSourceAndInfo dataSourceAndInfo) throws SQLException {
        DataSourceInfo info = dataSourceAndInfo.getDataSourceInfo();
        Connection connection = dataSourceAndInfo.getDataSource().getConnection();//NOSONAR
        connection.setClientInfo("LOCALE", null); // workaround for HANA bug
        try (Statement statement = connection.createStatement()) {
            logger.debug("Reconnect connection for user {}", info.getUser());
            statement.execute("connect " + info.getUser() +
                    " password \"" + info.getPassword() + "\" ");
            logger.debug("Set schema to {}", info.getSchema());
            connection.setSchema(info.getSchema());
            if (!connection.getSchema().equals(info.getSchema())) {
                throw new SQLException("Could not set schema " + info.getSchema());
            }
        } catch (SQLException sqlException) {
            connection.close();
            throw sqlException;
        }
        return connection;
    }
}
