/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.runtime;

import com.sap.cloud.mt.runtime.ConnectionProvider;
import com.sap.cloud.mt.runtime.DataSourceAndInfo;
import com.sap.cloud.mt.subscription.DataSourceInfo;
import java.sql.Connection;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericConnectionProvider
implements ConnectionProvider {
    private static Logger logger = LoggerFactory.getLogger(GenericConnectionProvider.class);

    @Override
    public Connection getConnection(String tenantId, DataSourceAndInfo dataSourceAndInfo) throws SQLException {
        DataSourceInfo info = dataSourceAndInfo.getDataSourceInfo();
        Connection connection = dataSourceAndInfo.getDataSource().getConnection();
        logger.debug("Set schema to {}", (Object)info.getSchema());
        try {
            connection.setSchema(info.getSchema());
            if (!connection.getSchema().equals(info.getSchema())) {
                throw new SQLException("Could not set schema " + info.getSchema());
            }
        }
        catch (SQLException sqlException) {
            connection.close();
            throw sqlException;
        }
        return connection;
    }
}

