/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.runtime;

import com.sap.cloud.mt.runtime.DataSourceAndInfo;
import com.sap.cloud.mt.runtime.HealtCheckResult;
import com.sap.cloud.mt.subscription.DataSourceInfo;
import com.sap.cloud.mt.subscription.DbIdentifiers;
import com.sap.cloud.mt.subscription.InstanceLifecycleManager;
import com.sap.cloud.mt.subscription.MtxTools;
import com.sap.cloud.mt.subscription.SqlOperations;
import com.sap.cloud.mt.subscription.TenantMutex;
import com.sap.cloud.mt.subscription.TenantMutexFactory;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.cloud.mt.subscription.exceptions.UnknownTenant;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataSourceLookup {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceLookup.class);
    private final ConcurrentHashMap<String, DataSourceAndInfo> tenantToDataSource = new ConcurrentHashMap();
    private final InstanceLifecycleManager instanceLifecycleManager;
    private final LibContainerCache libContainerCache = new LibContainerCache();
    private boolean oneDataSourcePerDb = false;

    protected DataSourceLookup(InstanceLifecycleManager instanceLifecycleManager, boolean oneDataSourcePerDb) {
        this.instanceLifecycleManager = instanceLifecycleManager;
        this.oneDataSourcePerDb = oneDataSourcePerDb;
    }

    protected DataSourceLookup(InstanceLifecycleManager instanceLifecycleManager) {
        this(instanceLifecycleManager, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataSourceAndInfo getDataSourceAndInfo(String tenantId) throws InternalError, UnknownTenant {
        logger.debug("Determine data source information for tenant {}", (Object)tenantId);
        DataSourceAndInfo dataSourceAndInfo = this.tenantToDataSource.get(tenantId);
        if (dataSourceAndInfo != null) {
            return dataSourceAndInfo;
        }
        TenantMutex tenantMutex = TenantMutexFactory.get((String)tenantId);
        synchronized (tenantMutex) {
            dataSourceAndInfo = this.tenantToDataSource.get(tenantId);
            if (dataSourceAndInfo != null) {
                return dataSourceAndInfo;
            }
            logger.debug("Access instance manager for tenant {}", (Object)tenantId);
            DataSourceInfo tenantDataSourceInfo = this.instanceLifecycleManager.getDataSourceInfo(tenantId, false);
            String dbKey = tenantDataSourceInfo.getDbKey();
            DataSource dataSource = null;
            if (this.oneDataSourcePerDb) {
                dataSource = this.libContainerCache.get(dbKey);
                if (dataSource == null) {
                    this.preparePool(tenantDataSourceInfo);
                    dataSource = this.libContainerCache.get(dbKey);
                    if (dataSource == null) {
                        throw new InternalError("Could not find database pool for db key " + dbKey);
                    }
                }
            } else {
                this.preparePool(tenantDataSourceInfo);
                dataSource = this.create(tenantDataSourceInfo);
            }
            DataSourceAndInfo newEntry = new DataSourceAndInfo(dataSource, tenantDataSourceInfo);
            this.tenantToDataSource.put(tenantId, newEntry);
            return newEntry;
        }
    }

    public void loadOneTenantPerDb() throws InternalError {
        HashMap dbKeyToTenants = new HashMap();
        ArrayList<String> tenantList = new ArrayList<String>(this.instanceLifecycleManager.getAllTenants(false));
        tenantList.sort(Comparator.comparing(String::toString));
        tenantList.stream().forEach(t -> {
            try {
                DataSourceInfo info = this.instanceLifecycleManager.getDataSourceInfo(t, false);
                String dbKey = info.getDbKey();
                List tenants = (List)dbKeyToTenants.get(dbKey);
                if (tenants == null) {
                    dbKeyToTenants.put(dbKey, new ArrayList());
                    tenants = (List)dbKeyToTenants.get(dbKey);
                }
                tenants.add(t);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        dbKeyToTenants.entrySet().stream().forEach(e -> {
            for (String tenant : (List)e.getValue()) {
                try {
                    this.getDataSourceAndInfo(tenant);
                    break;
                }
                catch (InternalError | UnknownTenant throwable) {
                }
            }
        });
    }

    public boolean isNotAuthenticationProblem(SQLException sqlException) {
        return !this.isAuthenticationProblem(sqlException);
    }

    public boolean isAuthenticationProblem(SQLException sqlException) {
        try {
            SqlOperations sqlOperations = SqlOperations.build((DbIdentifiers.DB)this.instanceLifecycleManager.getDbType());
            return sqlOperations.isAuthenticationProblem(this.determineSqlState(sqlException));
        }
        catch (InternalError e) {
            logger.error("Not supported DB", (Throwable)e);
            return false;
        }
    }

    protected String determineSqlState(Throwable exception) {
        SQLException sqlException;
        String sqlState;
        if (exception instanceof SQLException && StringUtils.isNotBlank((CharSequence)(sqlState = (sqlException = (SQLException)exception).getSQLState()))) {
            return sqlState;
        }
        if (exception.getCause() != null) {
            return this.determineSqlState(exception.getCause());
        }
        return "";
    }

    private synchronized void preparePool(DataSourceInfo dataSourceInfo) throws InternalError {
        logger.debug("Prepare pool for database key {}", (Object)dataSourceInfo.getDbKey());
        if (this.libContainerCache.isContained(dataSourceInfo.getDbKey())) {
            return;
        }
        List libContainers = this.instanceLifecycleManager.createAndGetLibContainers(dataSourceInfo);
        libContainers.stream().forEach(this::createAndCachePoolsForLibContainerPools);
    }

    private void createAndCachePoolsForLibContainerPools(DataSourceInfo libContainerInfo) {
        this.libContainerCache.createIfNotExist(libContainerInfo.getDbKey(), (MtxTools.SupplierWithInternalError<DataSource>)((MtxTools.SupplierWithInternalError)() -> this.create(libContainerInfo)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fixDataSourceAfterCredentialChange(String tenantId, DataSource usedPool) throws InternalError {
        if (StringUtils.isBlank((CharSequence)tenantId)) {
            logger.debug("No tenant specified");
            throw new InternalError("No tenant specified");
        }
        TenantMutex tenantMutex = TenantMutexFactory.get((String)tenantId);
        synchronized (tenantMutex) {
            DataSourceInfo freshInfo;
            DataSourceAndInfo dataSourceAndInfo = this.tenantToDataSource.get(tenantId);
            if (dataSourceAndInfo == null || usedPool != dataSourceAndInfo.getDataSource()) {
                return;
            }
            DataSourceInfo cachedInfo = dataSourceAndInfo.getDataSourceInfo();
            try {
                freshInfo = this.instanceLifecycleManager.getDataSourceInfo(tenantId, true);
            }
            catch (UnknownTenant unknownTenant) {
                freshInfo = null;
            }
            if (freshInfo == null) {
                this.adjustCacheAfterTenantDeletion(tenantId);
                logger.debug("Tenant was deleted");
                throw new InternalError("Tenant was deleted");
            }
            if (!this.credentialsChanged(cachedInfo, freshInfo)) {
                logger.debug("Normal database error");
                throw new InternalError("Normal database error");
            }
            this.adjustCacheAfterCredentialChange(tenantId, dataSourceAndInfo, freshInfo);
        }
    }

    private void adjustCacheAfterCredentialChange(String tenantId, DataSourceAndInfo dataSourceAndInfo, DataSourceInfo currentInfo) {
        if (!this.oneDataSourcePerDb) {
            this.deleteFromCache(tenantId);
        } else {
            dataSourceAndInfo.setDataSourceInfo(currentInfo);
        }
    }

    private boolean credentialsChanged(DataSourceInfo cached, DataSourceInfo current) {
        return !StringUtils.equals((CharSequence)current.getPassword(), (CharSequence)cached.getPassword()) || !StringUtils.equals((CharSequence)current.getUser(), (CharSequence)cached.getUser()) || !StringUtils.equals((CharSequence)current.getSchema(), (CharSequence)cached.getSchema()) || !StringUtils.equals((CharSequence)current.getDbKey(), (CharSequence)cached.getDbKey());
    }

    private void adjustCacheAfterTenantDeletion(String tenantId) {
        if (!this.oneDataSourcePerDb) {
            this.deleteFromCache(tenantId);
        } else {
            this.tenantToDataSource.remove(tenantId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteFromCache(String tenantId) {
        if (tenantId == null) {
            return;
        }
        logger.debug("Instance for tenant {} deleted from cache", (Object)tenantId);
        TenantMutex tenantMutex = TenantMutexFactory.get((String)tenantId);
        synchronized (tenantMutex) {
            DataSourceAndInfo dataSourceAndInfo = this.tenantToDataSource.get(tenantId);
            if (dataSourceAndInfo == null) {
                return;
            }
            this.tenantToDataSource.remove(tenantId);
            if (this.oneDataSourcePerDb) {
                long numberOfEntries = this.tenantToDataSource.entrySet().stream().filter(e -> ((DataSourceAndInfo)e.getValue()).getDataSource() == dataSourceAndInfo.getDataSource()).count();
                if (numberOfEntries == 0L) {
                    this.libContainerCache.remove(dataSourceAndInfo.getDataSourceInfo().getDbKey());
                    this.closeDataSource(dataSourceAndInfo.getDataSource());
                }
            } else {
                this.closeDataSource(dataSourceAndInfo.getDataSource());
            }
        }
    }

    public void reset() {
        if (this.oneDataSourcePerDb) {
            this.tenantToDataSource.clear();
            this.libContainerCache.reset();
        } else {
            this.tenantToDataSource.entrySet().stream().forEach(e -> this.closeDataSource(((DataSourceAndInfo)e.getValue()).getDataSource()));
            this.tenantToDataSource.clear();
        }
    }

    public List<DataSourceInfo> getCachedDataSource() {
        ArrayList<DataSourceInfo> result = new ArrayList<DataSourceInfo>();
        this.tenantToDataSource.entrySet().stream().forEach(e -> result.add(new DataSourceInfo(((DataSourceAndInfo)e.getValue()).getDataSourceInfo())));
        return result;
    }

    public List<HealtCheckResult> checkDataSourcePerDb(String dummySelectStatement) {
        ArrayList<HealtCheckResult> result = new ArrayList<HealtCheckResult>();
        try {
            this.instanceLifecycleManager.getLibContainers().stream().forEach(this::createAndCachePoolsForLibContainerPools);
        }
        catch (InternalError e2) {
            logger.error("Could not access containers owned by the mt-lib", (Throwable)e2);
            HealtCheckResult healtCheckResult = new HealtCheckResult("", false, (Exception)((Object)e2));
            result.add(healtCheckResult);
            return result;
        }
        this.libContainerCache.stream().forEach(e -> {
            try (Connection connection = ((DataSource)e.getValue()).getConnection();){
                SqlOperations sqlOperations = SqlOperations.build((DbIdentifiers.DB)this.instanceLifecycleManager.getDbType());
                sqlOperations.setDummySelectStatement(dummySelectStatement);
                sqlOperations.dummySelect(connection);
                HealtCheckResult healtCheckResult = new HealtCheckResult((String)e.getKey(), true, null);
                result.add(healtCheckResult);
            }
            catch (InternalError | SQLException exception) {
                HealtCheckResult healtCheckResult = new HealtCheckResult((String)e.getKey(), false, (Exception)exception);
                result.add(healtCheckResult);
            }
        });
        return result;
    }

    public void checkDataSource(String tenantId, String dummySelectStatement) throws SQLException {
        DataSourceAndInfo dataSourceAndInfo = this.tenantToDataSource.get(tenantId);
        if (dataSourceAndInfo == null) {
            throw new SQLException("Tenant " + tenantId + " doesn't exist");
        }
        try (Connection connection = dataSourceAndInfo.getDataSource().getConnection();){
            SqlOperations sqlOperations = SqlOperations.build((DbIdentifiers.DB)this.instanceLifecycleManager.getDbType());
            sqlOperations.setDummySelectStatement(dummySelectStatement);
            sqlOperations.dummySelect(connection);
        }
        catch (InternalError exception) {
            throw new SQLException(exception);
        }
    }

    boolean doesTenantExist(String tenantId) throws InternalError {
        try {
            this.instanceLifecycleManager.checkThatTenantExists(tenantId);
            return true;
        }
        catch (UnknownTenant unknownTenant) {
            return false;
        }
    }

    protected abstract DataSource create(DataSourceInfo var1) throws InternalError;

    protected abstract void closeDataSource(DataSource var1);

    public boolean isOneDataSourcePerDb() {
        return this.oneDataSourcePerDb;
    }

    public DbIdentifiers.DB getDbType() {
        return this.instanceLifecycleManager.getDbType();
    }

    public boolean hasDbIdentifiers() {
        return this.instanceLifecycleManager.hasDbIdentifiers();
    }

    public boolean knowsDbCredentials() {
        return this.instanceLifecycleManager.knowsDbCredentials();
    }

    private class LibContainerCache {
        private final ConcurrentHashMap<String, DataSource> dbKeyToLibContainer = new ConcurrentHashMap();

        private LibContainerCache() {
        }

        private boolean isContained(String dbKey) {
            return this.dbKeyToLibContainer.containsKey(dbKey);
        }

        private DataSource get(String dbKey) {
            return this.dbKeyToLibContainer.get(dbKey);
        }

        private DataSource remove(String dbKey) {
            return this.dbKeyToLibContainer.remove(dbKey);
        }

        private void reset() {
            this.dbKeyToLibContainer.entrySet().stream().forEach(e -> DataSourceLookup.this.closeDataSource((DataSource)e.getValue()));
            this.dbKeyToLibContainer.clear();
        }

        private Stream<Map.Entry<String, DataSource>> stream() {
            return this.dbKeyToLibContainer.entrySet().stream();
        }

        private void createIfNotExist(String dbKey, MtxTools.SupplierWithInternalError<DataSource> dataSourceSupplier) {
            try {
                this.dbKeyToLibContainer.putIfAbsent(dbKey, (DataSource)dataSourceSupplier.get());
            }
            catch (InternalError e) {
                logger.error("Cannot create data source pool", (Throwable)e);
            }
        }
    }
}

