/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.sap.cloud.mt.subscription.ClientCredentialJwtReaderIntf;
import com.sap.cloud.mt.subscription.exceptions.CommunicationError;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenResponse;
import java.time.Instant;

public class ClientCredentialJwtAccess {
    private final ClientCredentialJwtReaderIntf jwtReader;
    private volatile OAuth2TokenResponse oAuth2TokenResponse;

    public ClientCredentialJwtAccess(ClientCredentialJwtReaderIntf jwtReader) {
        this.jwtReader = jwtReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJwt() throws CommunicationError {
        OAuth2TokenResponse localRef = this.oAuth2TokenResponse;
        if (ClientCredentialJwtAccess.isTokenExpired(localRef)) {
            ClientCredentialJwtAccess clientCredentialJwtAccess = this;
            synchronized (clientCredentialJwtAccess) {
                localRef = this.oAuth2TokenResponse;
                if (ClientCredentialJwtAccess.isTokenExpired(localRef)) {
                    this.oAuth2TokenResponse = localRef = this.jwtReader.getJwt();
                }
            }
        }
        return localRef.getAccessToken();
    }

    private static boolean isTokenExpired(OAuth2TokenResponse tokenResponse) {
        return tokenResponse == null || Instant.now().isAfter(tokenResponse.getExpiredAt());
    }
}

