/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.sap.cloud.mt.subscription.DbIdentifiers;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class DbIdentifiersHana
implements DbIdentifiers {
    private Set<String> dbIds;

    public DbIdentifiersHana(Set<String> dbIds) {
        this.dbIds = dbIds == null ? new HashSet<String>() : dbIds;
    }

    public DbIdentifiersHana(DbIdentifiersHana dbIdentifiers) {
        this.dbIds = new HashSet<String>();
        dbIdentifiers.dbIds.stream().forEach(this.dbIds::add);
    }

    public Set<String> getDbIds() {
        return Collections.unmodifiableSet(this.dbIds);
    }

    public void add(String dbId) {
        this.dbIds.add(dbId);
    }

    public void remove(String dbId) {
        this.dbIds.remove(dbId);
    }

    @Override
    public boolean areSet() {
        return this.dbIds != null && this.dbIds.size() > 0;
    }

    @Override
    public DbIdentifiers.DB getDB() {
        return DbIdentifiers.DB.HANA;
    }

    @Override
    public DbIdentifiers createCopy() {
        return new DbIdentifiersHana(this);
    }
}

