/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.sap.cloud.mt.subscription.ConsumerWithException;
import com.sap.cloud.mt.subscription.SupplierWithException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Retry {
    private final int numOfRetries;
    private final List<Class> retryExceptions = new ArrayList<Class>();
    private final Duration waitTime;

    private Retry(int numOfRetries, List<Class> retryExceptions, Duration waitTime) {
        this.numOfRetries = numOfRetries;
        this.retryExceptions.addAll(retryExceptions);
        this.waitTime = waitTime != null ? waitTime : Duration.ofSeconds(1L);
    }

    public <T> T execute(SupplierWithException<T> supplier) throws Exception {
        int retryRun = -1;
        while (true) {
            ++retryRun;
            try {
                return supplier.get();
            }
            catch (Throwable e) {
                if (retryRun < this.numOfRetries && this.isARetryException(e)) {
                    this.sleep();
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public void execute(ConsumerWithException consumer) throws Exception {
        int retryRun = -1;
        while (true) {
            ++retryRun;
            try {
                consumer.accept();
                return;
            }
            catch (Throwable e) {
                if (retryRun < this.numOfRetries && this.isARetryException(e)) {
                    this.sleep();
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    private void sleep() {
        try {
            Thread.sleep(this.waitTime.toMillis());
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private boolean isARetryException(Throwable e) {
        return this.retryExceptions.stream().anyMatch(clazz -> clazz.isInstance(e));
    }

    public static final class RetryBuilder {
        private int numOfRetries;
        private List<Class> retryExceptions = new ArrayList<Class>();
        private Duration waitTime;

        private RetryBuilder() {
        }

        public static RetryBuilder create() {
            return new RetryBuilder();
        }

        public RetryBuilder numOfRetries(int numOfRetries) {
            this.numOfRetries = numOfRetries;
            return this;
        }

        public RetryBuilder retryExceptions(Class ... retryExceptions) {
            this.retryExceptions = Arrays.asList(retryExceptions);
            return this;
        }

        public RetryBuilder waitTime(Duration waitTime) {
            this.waitTime = waitTime;
            return this;
        }

        public Retry build() {
            return new Retry(this.numOfRetries, this.retryExceptions, this.waitTime);
        }
    }
}

