/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.sap.cloud.mt.subscription.Tools;
import com.sap.cloud.mt.subscription.exceptions.CommunicationProblem;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.cloud.mt.subscription.exceptions.NotFound;
import com.sap.cloud.mt.subscription.json.ApplicationForSidecar;
import com.sap.cloud.mt.subscription.json.DeletePayload;
import com.sap.cloud.mt.subscription.json.ManagedHanaForSidecar;
import com.sap.cloud.mt.subscription.json.SAPForSidecar;
import com.sap.cloud.mt.subscription.json.SidecarSubscriptionPayload;
import com.sap.cloud.mt.subscription.json.SidecarUnSubscriptionPayload;
import com.sap.cloud.mt.subscription.json.SidecarUpgradePayload;
import com.sap.cloud.mt.subscription.json.SubscriptionPayload;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultHttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.xsa.core.instancemanager.client.InstanceCreationOptions;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SidecarAccess {
    private static final Logger logger = LoggerFactory.getLogger(SidecarAccess.class);
    private static final String SIDECAR_PROVISIONING_ENDPOINT = "/mtx/v1/provisioning/tenant/";
    private static final String SIDECAR_UPGRADE_ENDPOINT = "/mtx/v1/model/asyncUpgrade";
    private static final String SIDECAR_STATUS_ENDPOINT = "/mtx/v1/model/status/";
    private static final String APPLICATION_JSON = "application/json";
    private static final String STATUS_CALLBACK = "STATUS_CALLBACK";
    private static final String MT_LIB_CALLBACK_URL = "MTX_STATUS_CALLBACK";
    private static final String MTX_SIDECAR_DESTINATION = "com.sap.cds.mtxSidecar";
    private static final String SIDECAR_RETURNED_HTTP_STATUS = "Sidecar returned http status ";
    private final String sidecarUrl;
    private final AtomicReference<HttpDestination> atomicSidecarHttpDestination = new AtomicReference();

    SidecarAccess(String sidecarUrl) {
        this.sidecarUrl = sidecarUrl;
    }

    public String callSidecarUpgrade(String jwt, SidecarUpgradePayload upgradePayload) throws InternalError, CommunicationProblem, IOException {
        HttpClient httpClient = this.getHttpClient();
        RequestBuilder builder = RequestBuilder.post((String)SIDECAR_UPGRADE_ENDPOINT);
        this.setAuthorizationHeader(jwt, builder);
        HttpUriRequest postRequest = builder.setHeader("Accept", APPLICATION_JSON).setHeader("Content-Type", APPLICATION_JSON).setEntity((HttpEntity)new StringEntity(this.convertPayloadToString(upgradePayload))).build();
        Throwable throwable = null;
        try (CloseableHttpResponse response = (CloseableHttpResponse)httpClient.execute(postRequest);){
            block19: {
                int responseCode = response.getStatusLine().getStatusCode();
                if (responseCode != 200) {
                    logger.error("Sidecar returned http status {} ", (Object)responseCode);
                    throw new CommunicationProblem(SIDECAR_RETURNED_HTTP_STATUS + responseCode);
                }
                try {
                    if (response.getEntity() != null) break block19;
                    String string = "";
                    return string;
                }
                catch (IOException e) {
                    try {
                        logger.error("Cannot access return value from sidecar. Error is {}", (Object)e.getMessage());
                        throw new InternalError("Cannot access return value from sidecar.", e);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
            }
            String string = EntityUtils.toString((HttpEntity)response.getEntity());
            return string;
        }
    }

    /*
     * Loose catch block
     */
    public String callSidecarStatus(String jobId, String jwt) throws InternalError, NotFound, CommunicationProblem, IOException {
        HttpClient httpClient = this.getHttpClient();
        RequestBuilder builder = RequestBuilder.get((String)(SIDECAR_STATUS_ENDPOINT + jobId));
        this.setAuthorizationHeader(jwt, builder);
        HttpUriRequest getRequest = builder.setHeader("Accept", APPLICATION_JSON).build();
        CloseableHttpResponse response = (CloseableHttpResponse)httpClient.execute(getRequest);
        Throwable throwable = null;
        int responseCode = response.getStatusLine().getStatusCode();
        if (responseCode == 404) {
            throw new NotFound("Job id not known");
        }
        if (responseCode != 200) {
            throw new CommunicationProblem(SIDECAR_RETURNED_HTTP_STATUS + responseCode);
        }
        if (response.getEntity() == null) {
            String string = "";
            return string;
        }
        String string = EntityUtils.toString((HttpEntity)response.getEntity());
        return string;
        {
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        finally {
            if (response != null) {
                if (throwable != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    response.close();
                }
            }
        }
    }

    public void callSidecarSubscribe(String tenantId, String jwt, SubscriptionPayload subscriptionPayload, InstanceCreationOptions instanceCreationOptions, String applicationUrl, boolean asyncCall, String saasRegistryUrl, String asyncSubscribeCallBackUrl) throws InternalError, CommunicationProblem, IOException {
        HttpClient httpClient = this.getHttpClient();
        SidecarSubscriptionPayload sidecarPayload = this.getSubscriptionPayloadForSidecar(subscriptionPayload, instanceCreationOptions);
        sidecarPayload._applicationUrlFromJava_ = applicationUrl;
        RequestBuilder builder = RequestBuilder.put((String)(SIDECAR_PROVISIONING_ENDPOINT + tenantId));
        this.setAuthorizationHeader(jwt, builder);
        RequestBuilder buildPutRequest = builder.setHeader("Accept", APPLICATION_JSON).setHeader("Content-Type", APPLICATION_JSON).setEntity((HttpEntity)new StringEntity(this.convertPayloadToString(sidecarPayload)));
        if (asyncCall) {
            buildPutRequest.setHeader(MT_LIB_CALLBACK_URL, asyncSubscribeCallBackUrl);
            buildPutRequest.setHeader(STATUS_CALLBACK, saasRegistryUrl);
        }
        HttpUriRequest putRequest = buildPutRequest.build();
        try (CloseableHttpResponse response = (CloseableHttpResponse)httpClient.execute(putRequest);){
            int responseCode = response.getStatusLine().getStatusCode();
            if (responseCode != 201 && responseCode != 200 && responseCode != 202) {
                logger.error("Sidecar returned http status {} ", (Object)responseCode);
                throw new CommunicationProblem(SIDECAR_RETURNED_HTTP_STATUS + responseCode);
            }
        }
    }

    public void callSidecarUnsubscribe(String tenantId, String jwt, DeletePayload deletePayloadCopy, boolean asyncCall, String saasRegistryUrl, String asyncUnsubscribeCallBackUrl) throws InternalError, CommunicationProblem, IOException {
        HttpClient httpClient = this.getHttpClient();
        SidecarUnSubscriptionPayload sidecarPayload = new SidecarUnSubscriptionPayload(deletePayloadCopy);
        RequestBuilder builder = RequestBuilder.delete((String)(SIDECAR_PROVISIONING_ENDPOINT + tenantId));
        this.setAuthorizationHeader(jwt, builder);
        RequestBuilder buildDelRequest = builder.setHeader("Accept", APPLICATION_JSON).setHeader("Content-Type", APPLICATION_JSON);
        if (asyncCall) {
            buildDelRequest.setHeader(MT_LIB_CALLBACK_URL, asyncUnsubscribeCallBackUrl);
            buildDelRequest.setHeader(STATUS_CALLBACK, saasRegistryUrl);
            buildDelRequest.setEntity((HttpEntity)new StringEntity(this.convertPayloadToString(sidecarPayload)));
        }
        HttpUriRequest delRequest = buildDelRequest.build();
        try (CloseableHttpResponse response = (CloseableHttpResponse)httpClient.execute(delRequest);){
            int responseCode = response.getStatusLine().getStatusCode();
            if (responseCode != 202 && responseCode != 204) {
                throw new CommunicationProblem(SIDECAR_RETURNED_HTTP_STATUS + responseCode);
            }
        }
    }

    private HttpDestination getSidecarDestination() throws InternalError {
        HttpDestination sidecarHttpDestination = this.atomicSidecarHttpDestination.get();
        if (sidecarHttpDestination == null) {
            try {
                sidecarHttpDestination = DestinationAccessor.getDestination((String)MTX_SIDECAR_DESTINATION).asHttp();
            }
            catch (DestinationAccessException e) {
                try {
                    sidecarHttpDestination = DefaultHttpDestination.builder((String)this.sidecarUrl).name(MTX_SIDECAR_DESTINATION).build();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new InternalError(illegalArgumentException);
                }
            }
            if (!this.atomicSidecarHttpDestination.compareAndSet(null, sidecarHttpDestination)) {
                return this.atomicSidecarHttpDestination.get();
            }
        }
        return sidecarHttpDestination;
    }

    private HttpClient getHttpClient() throws InternalError {
        return HttpClientAccessor.getHttpClient((HttpDestinationProperties)this.getSidecarDestination());
    }

    private void setAuthorizationHeader(String jwt, RequestBuilder builder) {
        if (jwt != null && !jwt.isEmpty()) {
            builder.setHeader("Authorization", jwt);
        }
    }

    private SidecarSubscriptionPayload getSubscriptionPayloadForSidecar(SubscriptionPayload subscriptionPayload, InstanceCreationOptions instanceCreationOptions) {
        SidecarSubscriptionPayload payload = new SidecarSubscriptionPayload(subscriptionPayload);
        boolean hasProvisioningParameters = false;
        boolean hasBindingParameters = false;
        if (instanceCreationOptions != null) {
            if (instanceCreationOptions.getProvisioningParameters() != null && instanceCreationOptions.getProvisioningParameters().size() > 0) {
                hasProvisioningParameters = true;
            }
            if (instanceCreationOptions.getBindingParameters() != null && instanceCreationOptions.getBindingParameters().size() > 0) {
                hasBindingParameters = true;
            }
        }
        if (hasProvisioningParameters || hasBindingParameters) {
            payload._application_ = new ApplicationForSidecar();
            payload._application_.sap = new SAPForSidecar();
            payload._application_.sap.managedHana = new ManagedHanaForSidecar();
            if (hasProvisioningParameters) {
                payload._application_.sap.managedHana.provisioning_parameters = instanceCreationOptions.getProvisioningParameters();
            }
            if (hasBindingParameters) {
                payload._application_.sap.managedHana.binding_parameters = instanceCreationOptions.getBindingParameters();
            }
        }
        return payload;
    }

    private String convertPayloadToString(Object payload) throws JsonProcessingException {
        String body = "{}";
        if (payload != null) {
            body = Tools.getObjectMapper().writeValueAsString(payload);
        }
        return body;
    }
}

