/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.sap.cloud.mt.subscription.AbstractSubscriber;
import com.sap.cloud.mt.subscription.DataSourceInfo;
import com.sap.cloud.mt.subscription.DbDeployer;
import com.sap.cloud.mt.subscription.FilterTenants;
import com.sap.cloud.mt.subscription.InstanceLifecycleManager;
import com.sap.cloud.mt.subscription.SaasRegistry;
import com.sap.cloud.mt.subscription.SecurityChecker;
import com.sap.cloud.mt.subscription.Tools;
import com.sap.cloud.mt.subscription.UiUrlCreator;
import com.sap.cloud.mt.subscription.exceptions.AuthorityError;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.cloud.mt.subscription.exceptions.NotSupported;
import com.sap.cloud.mt.subscription.exceptions.ParameterError;
import com.sap.cloud.mt.subscription.exceptions.UnknownTenant;
import com.sap.cloud.mt.subscription.exits.AfterSubscribeMethod;
import com.sap.cloud.mt.subscription.exits.AfterUnSubscribeMethod;
import com.sap.cloud.mt.subscription.exits.BeforeSubscribeMethod;
import com.sap.cloud.mt.subscription.exits.BeforeUnSubscribeMethod;
import com.sap.cloud.mt.subscription.exits.Exits;
import com.sap.cloud.mt.subscription.json.ApplicationDependency;
import com.sap.cloud.mt.subscription.json.Cloner;
import com.sap.cloud.mt.subscription.json.DeletePayload;
import com.sap.cloud.mt.subscription.json.SidecarSubscribeCallBackPayload;
import com.sap.cloud.mt.subscription.json.SidecarUnSubscribeCallBackPayload;
import com.sap.cloud.mt.subscription.json.SubscriptionPayload;
import com.sap.xsa.core.instancemanager.client.InstanceCreationOptions;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriberImpl
extends AbstractSubscriber {
    public static final String ALL_TENANTS = "all";
    private static final Logger logger = LoggerFactory.getLogger(SubscriberImpl.class);
    private static final String UPDATE = "UPDATE";
    private final InstanceLifecycleManager instanceLifecycleManager;
    private final DbDeployer dbDeployer;
    private final Exits exits;
    private final String baseUiUrl;
    private final String urlSeparator;
    private final SecurityChecker securityChecker;
    private final SaasRegistry saasRegistry;
    private static final ExecutorService executorService = Executors.newSingleThreadExecutor();

    SubscriberImpl(InstanceLifecycleManager instanceLifecycleManager, DbDeployer dbDeployer, String baseUiUrl, String urlSeparator, Exits exits, SecurityChecker securityChecker, SaasRegistry saasRegistry) throws InternalError {
        this.instanceLifecycleManager = instanceLifecycleManager;
        this.dbDeployer = dbDeployer;
        this.exits = exits;
        this.baseUiUrl = baseUiUrl;
        this.urlSeparator = urlSeparator;
        if (exits.getUnSubscribeExit() == null) {
            throw new InternalError("No unsubscribe exit found");
        }
        this.securityChecker = securityChecker;
        this.saasRegistry = saasRegistry;
    }

    @Override
    public void unsubscribe(String tenantId, DeletePayload deletePayload, String jwt) throws InternalError, ParameterError, AuthorityError {
        this.unsubscribe(tenantId, deletePayload, jwt, null, null);
    }

    @Override
    public void unsubscribe(String tenantId, DeletePayload deletePayload, String jwt, String saasRegistryUrl, String asyncUnSubscribeCallBackUrl) throws InternalError, ParameterError, AuthorityError {
        AfterUnSubscribeMethod afterUnSubscribeMethod;
        BeforeUnSubscribeMethod beforeUnSubscribeMethod;
        boolean asyncCall = this.isAsyncCall(saasRegistryUrl);
        this.securityChecker.checkSubscriptionAuthority();
        Tools.checkExternalTenantId(tenantId);
        if (asyncCall) {
            beforeUnSubscribeMethod = this.exits.getUnSubscribeExit()::onBeforeAsyncUnsubscribe;
            afterUnSubscribeMethod = this.exits.getUnSubscribeExit()::onAfterAsyncUnsubscribe;
        } else {
            beforeUnSubscribeMethod = this.exits.getUnSubscribeExit()::onBeforeUnsubscribe;
            afterUnSubscribeMethod = this.exits.getUnSubscribeExit()::onAfterUnsubscribe;
        }
        boolean processUnsubscribe = beforeUnSubscribeMethod.call(tenantId, Cloner.clone(deletePayload));
        if (processUnsubscribe) {
            if (asyncCall) {
                this.unsubscribeAsynchronously(tenantId, saasRegistryUrl, deletePayload, afterUnSubscribeMethod);
            } else {
                this.deleteInstance(tenantId, deletePayload, afterUnSubscribeMethod);
            }
        } else {
            logger.debug("Unsubscribe exit returned false=> No unsubscription performed");
        }
    }

    private boolean isAsyncCall(String saasRegistryUrl) {
        return saasRegistryUrl != null && !saasRegistryUrl.isEmpty();
    }

    private void unsubscribeAsynchronously(String tenantId, String saasRegistryUrl, DeletePayload deletePayload, AfterUnSubscribeMethod afterUnSubscribeMethod) throws InternalError {
        if (this.saasRegistry == null) {
            logger.error("No saas registry service instance bound to application");
            throw new InternalError("No saas registry service instance bound to application");
        }
        CompletableFuture<Void> onBoard = CompletableFuture.runAsync(() -> {
            long startTime = System.nanoTime();
            try {
                this.deleteInstance(tenantId, deletePayload, afterUnSubscribeMethod);
                this.waitSomeTime(startTime);
                this.saasRegistry.callBackSaasRegistry(true, null, null, saasRegistryUrl);
            }
            catch (InternalError e) {
                logger.error(e.getMessage());
                this.waitSomeTime(startTime);
                try {
                    this.saasRegistry.callBackSaasRegistry(false, e.getMessage(), null, saasRegistryUrl);
                }
                catch (InternalError internalError) {
                    logger.error(internalError.getMessage());
                }
            }
        }, executorService);
    }

    @Override
    public List<ApplicationDependency> getApplicationDependencies(String jwt) throws AuthorityError {
        this.securityChecker.checkSubscriptionAuthority();
        return this.exits.getDependencyExit().onGetDependencies();
    }

    @Override
    public String subscribe(String tenantId, SubscriptionPayload subscriptionPayload, String jwt) throws InternalError, ParameterError, AuthorityError {
        return this.subscribe(tenantId, subscriptionPayload, jwt, null, null);
    }

    @Override
    public String subscribe(String tenantId, SubscriptionPayload subscriptionPayload, String jwt, String saasRegistryUrl, String asyncSubscribeCallBackUrl) throws InternalError, ParameterError, AuthorityError {
        String subscriptionUrl;
        AfterSubscribeMethod afterExit;
        BeforeSubscribeMethod beforeExit;
        boolean asyncCall = this.isAsyncCall(saasRegistryUrl);
        this.securityChecker.checkSubscriptionAuthority();
        Tools.checkExternalTenantId(tenantId);
        if (asyncCall) {
            beforeExit = this.exits.getSubscribeExit()::onBeforeAsyncSubscribe;
            afterExit = this.exits.getSubscribeExit()::onAfterAsyncSubscribe;
        } else {
            beforeExit = this.exits.getSubscribeExit()::onBeforeSubscribe;
            afterExit = this.exits.getSubscribeExit()::onAfterSubscribe;
        }
        InstanceCreationOptions instanceCreationOptions = null;
        try {
            instanceCreationOptions = beforeExit.call(tenantId, Cloner.clone(subscriptionPayload));
        }
        catch (InternalError internalError) {
            logger.error(internalError.getMessage());
            afterExit.call(tenantId, Cloner.clone(subscriptionPayload), false);
            throw internalError;
        }
        URL urlFromExit = this.exits.getSubscribeExit().uiURL();
        if (urlFromExit == null) {
            urlFromExit = this.exits.getSubscribeExit().uiURL(Cloner.clone(subscriptionPayload));
        }
        String string = subscriptionUrl = urlFromExit != null ? urlFromExit.toExternalForm() : null;
        if (subscriptionPayload == null || subscriptionPayload.subscribedSubdomain == null) {
            if (subscriptionPayload == null) {
                throw new ParameterError("No subscription payload available");
            }
            throw new ParameterError("No sub domain passed in subscription payload");
        }
        if (subscriptionUrl == null) {
            subscriptionUrl = UiUrlCreator.createUrl(subscriptionPayload.subscribedSubdomain, this.baseUiUrl, this.urlSeparator);
        }
        if (asyncCall) {
            this.subscribeAsynchronously(tenantId, jwt, saasRegistryUrl, subscriptionPayload, afterExit, instanceCreationOptions, subscriptionUrl);
        } else {
            this.createInstanceAndOnBoard(tenantId, subscriptionPayload, jwt, subscriptionUrl, instanceCreationOptions, afterExit, false);
        }
        return subscriptionUrl;
    }

    private void subscribeAsynchronously(String tenantId, String jwt, String saasRegistryUrl, SubscriptionPayload subscriptionPayload, AfterSubscribeMethod afterExit, InstanceCreationOptions instanceCreationOptions, String subscriptionUrl) throws InternalError {
        if (this.saasRegistry == null) {
            logger.error("No saas registry service instance bound to application");
            throw new InternalError("No saas registry service instance bound to application");
        }
        String finalSubscriptionUrl = subscriptionUrl;
        InstanceCreationOptions finalInstanceCreationOptions = Cloner.clone(instanceCreationOptions);
        CompletableFuture<Void> onBoard = CompletableFuture.runAsync(() -> {
            long startTime = System.nanoTime();
            try {
                this.createInstanceAndOnBoard(tenantId, subscriptionPayload, jwt, finalSubscriptionUrl, finalInstanceCreationOptions, afterExit, true);
                this.waitSomeTime(startTime);
                this.saasRegistry.callBackSaasRegistry(true, null, finalSubscriptionUrl, saasRegistryUrl);
            }
            catch (AuthorityError | InternalError | ParameterError e) {
                logger.error(e.getMessage());
                this.waitSomeTime(startTime);
                try {
                    this.saasRegistry.callBackSaasRegistry(false, e.getMessage(), null, saasRegistryUrl);
                }
                catch (InternalError internalError) {
                    logger.error(e.getMessage());
                }
            }
        }, executorService);
    }

    @Override
    public void setupDbTables(List<String> tenants, String jwt) throws InternalError, ParameterError, AuthorityError {
        this.securityChecker.checkInitDbAuthority();
        this.setupDbTablesInt(tenants, jwt, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String setupDbTablesAsync(List<String> tenants, String jwt) throws ParameterError, AuthorityError {
        this.securityChecker.checkInitDbAuthority();
        for (String tenantId : tenants) {
            Tools.checkExternalTenantId(tenantId);
        }
        ExecutorService executor = null;
        try {
            executor = Executors.newSingleThreadExecutor();
            CompletableFuture.supplyAsync(() -> {
                try {
                    this.setupDbTablesInt(tenants, jwt, true);
                }
                catch (InternalError internalError) {
                    logger.error("Could not init DB asynchronously. Error is {}", (Object)internalError.getMessage());
                }
                catch (ParameterError parameterError) {
                }
                catch (AuthorityError authorityError) {
                    // empty catch block
                }
                return "";
            }, executor);
        }
        finally {
            if (executor != null) {
                executor.shutdown();
            }
        }
        return "";
    }

    @Override
    public String updateStatus(String jobId, String jwt) throws NotSupported, InternalError, AuthorityError {
        this.securityChecker.checkInitDbAuthority();
        logger.debug("Update status is only supported with sidecar");
        throw new NotSupported("Update status is only supported with sidecar");
    }

    private void setupDbTablesInt(List<String> tenants, String jwt, boolean async) throws InternalError, ParameterError, AuthorityError {
        for (String tenantId2 : tenants) {
            Tools.checkExternalTenantId(tenantId2);
        }
        if (tenants.size() == 1 && tenants.get(0).equals(ALL_TENANTS)) {
            this.setupDbTables(new ArrayList<String>(this.instanceLifecycleManager.getAllTenants()), jwt);
            return;
        }
        if (this.exits.getInitDbExit() != null) {
            this.exits.getInitDbExit().onBeforeInitDb(tenants);
        }
        String[] message = new String[]{""};
        tenants.stream().filter(FilterTenants.realTenants()).forEach(tenantId -> {
            try {
                DataSourceInfo dataSourceAndInfo = this.instanceLifecycleManager.getDataSourceInfo((String)tenantId, false);
                this.dbDeployer.populate(dataSourceAndInfo, (String)tenantId, async);
            }
            catch (InternalError e) {
                if (message[0].isEmpty()) {
                    message[0] = "Error in deployment:";
                }
                message[0] = message[0] + "\n Could not perform deployment for tenant " + tenantId;
            }
            catch (UnknownTenant unknownTenant) {
                // empty catch block
            }
        });
        if (this.exits.getInitDbExit() != null) {
            this.exits.getInitDbExit().onAfterInitDb(message[0].isEmpty());
        }
        if (!message[0].isEmpty()) {
            throw new InternalError(message[0]);
        }
    }

    private void deleteInstance(String tenantId, DeletePayload deletePayload, AfterUnSubscribeMethod afterUnSubscribeMethod) throws InternalError {
        this.instanceLifecycleManager.deleteInstance(tenantId);
        afterUnSubscribeMethod.call(tenantId, Cloner.clone(deletePayload));
    }

    public String createInstanceAndOnBoard(String tenantId, SubscriptionPayload subscriptionPayload, String jwt, String url, InstanceCreationOptions instanceCreationOptions, AfterSubscribeMethod exit, boolean async) throws InternalError, ParameterError, AuthorityError {
        InstanceLifecycleManager.ContainerStatus instanceStatus = this.instanceLifecycleManager.getContainerStatus(tenantId);
        if (instanceStatus == InstanceLifecycleManager.ContainerStatus.CREATION_ERROR) {
            logger.debug("Container for tenant {} has status CREATION_FAILED", (Object)tenantId);
            logger.debug("Delete container to fix problem");
            this.instanceLifecycleManager.deleteInstance(tenantId);
            instanceStatus = this.instanceLifecycleManager.getContainerStatus(tenantId);
        }
        logger.debug("Subscribe tenant " + tenantId);
        if (instanceStatus == InstanceLifecycleManager.ContainerStatus.OK) {
            try {
                DataSourceInfo dataSourceInfo = this.instanceLifecycleManager.getDataSourceInfo(tenantId, false);
                if (subscriptionPayload.eventType != null && subscriptionPayload.eventType.equalsIgnoreCase(UPDATE)) {
                    logger.debug("Event type is DEBUG, no DB deployment performed");
                } else {
                    this.dbDeployer.populate(dataSourceInfo, tenantId, async);
                }
                exit.call(tenantId, Cloner.clone(subscriptionPayload), true);
                return url;
            }
            catch (UnknownTenant unknownTenant) {
                logger.error("Tenant {} was deleted in parallel session", (Object)tenantId);
                exit.call(tenantId, Cloner.clone(subscriptionPayload), false);
                throw new InternalError("Tenant was deleted in parallel session");
            }
            catch (InternalError internalError) {
                logger.error("Could not deploy to DB container for tenant " + tenantId);
                exit.call(tenantId, Cloner.clone(subscriptionPayload), false);
                throw internalError;
            }
        }
        if (instanceStatus == InstanceLifecycleManager.ContainerStatus.DOES_NOT_EXIST) {
            logger.debug("Create new instance for tenant " + tenantId);
            this.instanceLifecycleManager.createNewInstance(tenantId, instanceCreationOptions);
            DataSourceInfo dataSourceInfo = null;
            try {
                dataSourceInfo = this.instanceLifecycleManager.getDataSourceInfo(tenantId, false);
            }
            catch (UnknownTenant unknownTenant) {
                logger.error("Tenant {} was deleted in parallel session", (Object)tenantId);
                exit.call(tenantId, Cloner.clone(subscriptionPayload), false);
                throw new InternalError("Could not create DB container");
            }
            logger.debug("Populate schema for new for tenant " + tenantId);
            try {
                this.dbDeployer.populate(dataSourceInfo, tenantId, async);
                exit.call(tenantId, Cloner.clone(subscriptionPayload), true);
                return url;
            }
            catch (InternalError internalError) {
                logger.error("Could not deploy to DB container for tenant " + tenantId);
                try {
                    logger.debug("Delete DB container for tenant " + tenantId);
                    this.instanceLifecycleManager.deleteInstance(tenantId);
                }
                catch (Exception e) {
                    logger.error("Could not delete DB container for tenant " + tenantId);
                }
                exit.call(tenantId, Cloner.clone(subscriptionPayload), false);
                throw internalError;
            }
        }
        logger.error("Instance for tenant id {} has wrong status {}", (Object)tenantId, (Object)instanceStatus.toString());
        exit.call(tenantId, Cloner.clone(subscriptionPayload), false);
        throw new InternalError("Instance has wrong status");
    }

    @Override
    public void unsubscribeCallback(SidecarUnSubscribeCallBackPayload sidecarCallBackPayload, String jwt) throws InternalError, AuthorityError {
        throw new InternalError("Callback not supported without mtx/sidecar");
    }

    @Override
    public void subscribeCallback(String jwt, SidecarSubscribeCallBackPayload sidecarCallBackPayload) throws InternalError, AuthorityError {
        throw new InternalError("Callback not supported without mtx/sidecar");
    }

    @Override
    public DbDeployer getDbDeployer() {
        return this.dbDeployer;
    }
}

