/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.sap.cloud.mt.subscription.exceptions.InternalError;
import java.net.MalformedURLException;
import java.net.URL;

public class UiUrlCreator {
    public static String createUrl(String subDomain, String baseUiUrl, String urlSeparator) throws InternalError {
        if (subDomain == null || subDomain.trim().isEmpty()) {
            throw new InternalError("No subdomain specified");
        }
        boolean isBaseUiUrl = false;
        boolean isUrlSeparator = false;
        if (baseUiUrl != null && !baseUiUrl.trim().isEmpty()) {
            isBaseUiUrl = true;
        }
        if (urlSeparator != null && !urlSeparator.trim().isEmpty()) {
            isUrlSeparator = true;
        }
        if (!(isBaseUiUrl && isUrlSeparator || !isBaseUiUrl && !isUrlSeparator)) {
            throw new InternalError("You have specified one of the URL parameters baseUiUrl and urlSeparator, but not all of them.");
        }
        if (!isBaseUiUrl && !isUrlSeparator) {
            return "";
        }
        try {
            return new URL("https://" + subDomain + urlSeparator + UiUrlCreator.strippedBaseUiUrl(baseUiUrl)).toExternalForm();
        }
        catch (MalformedURLException e) {
            throw new InternalError(e);
        }
    }

    private static String strippedBaseUiUrl(String urlStr) {
        URL url = null;
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException e) {
            return urlStr;
        }
        return url.getHost();
    }
}

