/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.sap.cloud.mt.subscription.ClientCredentialJwtReaderIntf;
import com.sap.cloud.mt.subscription.XsuaaParams;
import com.sap.cloud.mt.subscription.exceptions.CommunicationError;
import com.sap.cloud.security.xsuaa.client.ClientCredentials;
import com.sap.cloud.security.xsuaa.client.DefaultOAuth2TokenService;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceEndpointsProvider;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenResponse;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenService;
import com.sap.cloud.security.xsuaa.client.XsuaaDefaultEndpoints;
import com.sap.cloud.security.xsuaa.tokenflows.TokenFlowException;
import com.sap.cloud.security.xsuaa.tokenflows.XsuaaTokenFlows;

public class ClientCredentialJwtReader
implements ClientCredentialJwtReaderIntf {
    private final XsuaaTokenFlows tokenFlows;

    public ClientCredentialJwtReader(XsuaaParams xsuaaParams) {
        this.tokenFlows = new XsuaaTokenFlows((OAuth2TokenService)new DefaultOAuth2TokenService(), (OAuth2ServiceEndpointsProvider)new XsuaaDefaultEndpoints(xsuaaParams.getUrl()), new ClientCredentials(xsuaaParams.getClientId(), xsuaaParams.getClientSecret()));
    }

    @Override
    public OAuth2TokenResponse getJwt() throws CommunicationError {
        try {
            return this.tokenFlows.clientCredentialsTokenFlow().execute();
        }
        catch (TokenFlowException e) {
            throw new CommunicationError("Could not retrieve JWT.", e);
        }
    }
}

