/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.sap.cloud.mt.subscription.DbIdentifiers;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public abstract class DbCredentials {
    protected static final String JDBC = "jdbc:";
    private final String user;
    private final String password;
    private final String host;
    private final String port;
    private final String driver;
    protected final URI uri;

    protected DbCredentials(String user, String password, String host, String port, String driver, String uriStr) throws InternalError {
        this.user = user;
        this.password = password;
        this.host = host;
        this.port = port;
        this.driver = driver;
        this.uri = StringUtils.isNotEmpty((CharSequence)uriStr) ? this.getUri(uriStr) : null;
    }

    protected DbCredentials(DbCredentials dbCredentials) {
        this.user = dbCredentials.user;
        this.password = dbCredentials.password;
        this.host = dbCredentials.host;
        this.port = dbCredentials.port;
        this.driver = dbCredentials.driver;
        this.uri = dbCredentials.uri;
    }

    public abstract String getDatabaseId();

    public final String getUrl() {
        return this.buildUrl();
    }

    public abstract DbIdentifiers.DB getDB();

    public String getUser() {
        if (StringUtils.isNotEmpty((CharSequence)this.user)) {
            return this.user;
        }
        if (this.uri == null) {
            return "";
        }
        UserAndPassword userAndPassword = this.getUserFromUri(this.uri);
        return userAndPassword.user;
    }

    public String getPassword() {
        if (StringUtils.isNotEmpty((CharSequence)this.password)) {
            return this.password;
        }
        if (this.uri == null) {
            return "";
        }
        UserAndPassword userAndPassword = this.getUserFromUri(this.uri);
        return userAndPassword.password;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getHost() {
        if (StringUtils.isNotEmpty((CharSequence)this.host)) {
            return this.host;
        }
        if (this.uri == null) {
            return "";
        }
        List<HostAndPort> hostAndPorts = this.getHostsFromUri(this.uri);
        if (!hostAndPorts.isEmpty()) {
            return hostAndPorts.get((int)0).host;
        }
        return "";
    }

    public String getPort() {
        if (StringUtils.isNotEmpty((CharSequence)this.port)) {
            return this.port;
        }
        if (this.uri == null) {
            return "";
        }
        List<HostAndPort> hostAndPorts = this.getHostsFromUri(this.uri);
        if (!hostAndPorts.isEmpty()) {
            return hostAndPorts.get((int)0).port;
        }
        return "";
    }

    public abstract DbCredentials createCopy();

    private URI getUri(String uriStr) throws InternalError {
        if (StringUtils.isEmpty((CharSequence)uriStr)) {
            throw new InternalError("No uri set");
        }
        try {
            if (uriStr.startsWith(JDBC)) {
                return new URI(uriStr.substring(5));
            }
            return new URI(uriStr);
        }
        catch (URISyntaxException e) {
            throw new InternalError(e);
        }
    }

    protected abstract String buildUrl();

    protected abstract List<HostAndPort> getHostsFromUri(URI var1);

    protected abstract UserAndPassword getUserFromUri(URI var1);

    protected static class UserAndPassword {
        String user;
        String password;

        protected UserAndPassword() {
        }
    }

    protected static class HostAndPort {
        String host;
        String port;

        protected HostAndPort() {
        }
    }
}

