/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.sap.cloud.mt.subscription.DataSourceInfo;
import com.sap.cloud.mt.subscription.DbDeployer;
import com.sap.cloud.mt.subscription.LiquibaseResourceAccessor;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.annotation.Nullable;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;

public class DbDeployerLiquibase
implements DbDeployer {
    private final LiquibaseResourceAccessor resourceAccessorForTenant;
    private String fileName;
    private String contexts;

    public DbDeployerLiquibase(@Nullable LiquibaseResourceAccessor resourceAccessorForTenant, @Nullable String fileName, @Nullable String contexts) {
        this.fileName = fileName == null ? "" : fileName;
        this.contexts = contexts == null ? "" : contexts;
        this.resourceAccessorForTenant = resourceAccessorForTenant == null ? tenantId -> new ClassLoaderResourceAccessor() : resourceAccessorForTenant;
    }

    @Override
    public void populate(DataSourceInfo dataSourceInfo, String tenantId, boolean async) throws InternalError {
        try (Connection connection = this.getConnection(dataSourceInfo);){
            JdbcConnection liquibaseConnection = new JdbcConnection(connection);
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)liquibaseConnection);
            Liquibase liquibase = new Liquibase(this.fileName, this.resourceAccessorForTenant.getAccessor(tenantId), database);
            liquibase.update(this.contexts);
        }
        catch (SQLException | LiquibaseException sqlException) {
            throw new InternalError(sqlException);
        }
    }

    @Override
    public boolean isDeploymentFinished(String jobGuid) throws InternalError {
        throw new UnsupportedOperationException();
    }

    private Connection getConnection(DataSourceInfo dataSourceInfo) throws InternalError {
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(dataSourceInfo.getUrl(), dataSourceInfo.getUser(), dataSourceInfo.getPassword());
            connection.setSchema(dataSourceInfo.getSchema());
            if (!connection.getSchema().equals(dataSourceInfo.getSchema())) {
                connection.close();
                throw new InternalError("Could not set schema to " + dataSourceInfo.getSchema());
            }
            return connection;
        }
        catch (SQLException sqlException) {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            throw new InternalError(sqlException);
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getContexts() {
        return this.contexts;
    }

    public void setContexts(String contexts) {
        this.contexts = contexts;
    }
}

