/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cloud.mt.subscription.DataSourceInfo;
import com.sap.cloud.mt.subscription.DbDeployer;
import com.sap.cloud.mt.subscription.FilterTenants;
import com.sap.cloud.mt.subscription.StreamToJsonConverter;
import com.sap.cloud.mt.subscription.exceptions.HdiDeploymentCommunicationProblem;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.cloud.mt.subscription.exits.UserProvidedSchemasExit;
import com.sap.cloud.mt.subscription.json.AsyncDeploymentReturn;
import com.sap.cloud.mt.subscription.json.Credentials;
import com.sap.cloud.mt.subscription.json.DbHost;
import com.sap.cloud.mt.subscription.json.DeploymentPayload;
import com.sap.cloud.mt.subscription.json.DeploymentReturn;
import com.sap.cloud.mt.subscription.json.Hana;
import com.sap.cloud.mt.subscription.json.ImBasedCredentialsHdiDeployment;
import com.sap.cloud.mt.subscription.json.ImBasedHdiDeploymentPayload;
import com.sap.cloud.mt.subscription.json.UserProvidedSchema;
import com.sap.cloud.mt.subscription.json.VcapService;
import com.sap.cloud.mt.tools.impl.Retry;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Duration;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdiContainerManager
implements DbDeployer {
    public static final String TARGET_CONTAINER_NAME = "COMSAPICDMTHDI";
    private static final String APPLICATION_JSON = "application/json";
    private static final Logger logger = LoggerFactory.getLogger(HdiContainerManager.class);
    private static final int MAX_RETRIES = 1;
    private static final String DEPLOY_SYNC_PATH = "/v1/deploy";
    private static final String DEPLOY_ASYNC_PATH = "/v1/deploy/to/instance/async";
    private static final String STATUS_PATH = "/v1/status/";
    private static final long MAX_WAIT_TIME_IN_SECONDS_DEFAULT = 600L;
    private static final long WAIT_TIME_IN_SECONDS_DEFAULT = 5L;
    private final URI dynamicDeployementUri;
    private final URI dynamicDeployementUriAsync;
    private final String user;
    private final String password;
    private final String dynamicDeploymentUrlStr;
    private final long maxAsyncWaitTimeSeconds;
    private final long asyncPollTimeSeconds;
    private final UserProvidedSchemasExit userProvidedSchemasExit;

    public HdiContainerManager(String dynamicDeploymentUrlStr, String user, String password, long maxAsyncWaitTimeSeconds, long asyncPollTimeSeconds, UserProvidedSchemasExit userProvidedSchemasExit) throws InternalError {
        this.maxAsyncWaitTimeSeconds = maxAsyncWaitTimeSeconds;
        this.asyncPollTimeSeconds = asyncPollTimeSeconds;
        this.dynamicDeploymentUrlStr = dynamicDeploymentUrlStr;
        try {
            this.dynamicDeployementUri = new URL(dynamicDeploymentUrlStr + DEPLOY_SYNC_PATH).toURI();
            this.dynamicDeployementUriAsync = new URL(dynamicDeploymentUrlStr + DEPLOY_ASYNC_PATH).toURI();
        }
        catch (MalformedURLException e) {
            logger.error("Wrong URL for HDI deployment specified: " + dynamicDeploymentUrlStr);
            throw new InternalError("Wrong URL for HDI deployment specified: " + dynamicDeploymentUrlStr, e);
        }
        catch (URISyntaxException e) {
            logger.error("Wrong URL for HDI deployment specified: " + dynamicDeploymentUrlStr);
            throw new InternalError("Wrong URL for HDI deployment specified: " + dynamicDeploymentUrlStr, e);
        }
        this.user = user;
        this.password = password;
        this.userProvidedSchemasExit = userProvidedSchemasExit != null ? userProvidedSchemasExit : new UserProvidedSchemasExit(){};
    }

    public HdiContainerManager(String dynamicDeploymentUrlStr, String user, String password, long maxAsyncWaitTimeSeconds, long asyncPollTimeSeconds) throws InternalError {
        this(dynamicDeploymentUrlStr, user, password, maxAsyncWaitTimeSeconds, asyncPollTimeSeconds, null);
    }

    @Deprecated
    public HdiContainerManager(String dynamicDeploymentUrlStr, String user, String password) throws InternalError {
        this(dynamicDeploymentUrlStr, user, password, 600L, 5L, null);
    }

    @Deprecated
    public void populateHdiContainer(DataSourceInfo dataSourceInfo, String tenantId, boolean async) throws InternalError {
        this.populate(dataSourceInfo, tenantId, async);
    }

    @Override
    public void populate(DataSourceInfo dataSourceInfo, String tenantId, boolean async) throws InternalError {
        if (async) {
            String jobGuid = this.populateHdiContainerAsync(dataSourceInfo, tenantId);
            long startTime = System.currentTimeMillis();
            long passedTime = 0L;
            boolean finished = false;
            do {
                try {
                    Thread.sleep(this.asyncPollTimeSeconds * 1000L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                passedTime = (System.currentTimeMillis() - startTime) / 1000L;
            } while (!(finished = this.isDeploymentFinished(jobGuid)) && passedTime < this.maxAsyncWaitTimeSeconds);
            if (!finished) {
                logger.error("Deployment didn't finish in maximum time {}", (Object)this.maxAsyncWaitTimeSeconds);
                throw new InternalError("Deployment didn't finish in maximum time " + this.maxAsyncWaitTimeSeconds);
            }
        } else {
            Retry retry = Retry.RetryBuilder.create().waitTime(Duration.ofSeconds(1L)).numOfRetries(1).retryExceptions(new Class[]{HdiDeploymentCommunicationProblem.class}).build();
            try {
                retry.execute(() -> this.populateHdiContainerSync(dataSourceInfo, tenantId));
            }
            catch (Exception e) {
                throw new InternalError(e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String populateHdiContainerAsync(DataSourceInfo dataSourceInfo, String tenantId) throws InternalError {
        if (!FilterTenants.realTenants().test(tenantId)) {
            return null;
        }
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();){
            int responseCode;
            Throwable throwable;
            CloseableHttpResponse response;
            block28: {
                String string;
                block29: {
                    HttpUriRequest postRequest = RequestBuilder.post((URI)this.dynamicDeployementUriAsync).setHeader("Authorization", this.getAuthHeader()).setHeader("Accept", APPLICATION_JSON).setHeader("Content-Type", APPLICATION_JSON).setEntity((HttpEntity)new StringEntity(this.getBodyWithInstanceManagerBasedPayload(dataSourceInfo, tenantId))).build();
                    response = httpClient.execute(postRequest);
                    throwable = null;
                    responseCode = response.getStatusLine().getStatusCode();
                    if (responseCode != 200 && responseCode != 201) break block28;
                    AsyncDeploymentReturn deploymentReturn = null;
                    if (response.getEntity() != null) {
                        deploymentReturn = new StreamToJsonConverter<AsyncDeploymentReturn>(AsyncDeploymentReturn.class).asJson(EntityUtils.toString((HttpEntity)response.getEntity()));
                    }
                    if (deploymentReturn == null) throw new InternalError("Asynchronous HDI deployment didn't return a job guid");
                    if (deploymentReturn.guid == null) throw new InternalError("Asynchronous HDI deployment didn't return a job guid");
                    if (deploymentReturn.guid.isEmpty()) {
                        throw new InternalError("Asynchronous HDI deployment didn't return a job guid");
                    }
                    string = deploymentReturn.guid;
                    if (response == null) return string;
                    if (throwable == null) break block29;
                    try {
                        response.close();
                        return string;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                        return string;
                    }
                }
                response.close();
                return string;
            }
            try {
                try {
                    throw new InternalError("Deployment endpoint returned " + responseCode);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                if (response == null) throw throwable4;
                if (throwable == null) {
                    response.close();
                    throw throwable4;
                }
                try {
                    response.close();
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    throwable.addSuppressed(throwable5);
                    throw throwable4;
                }
            }
        }
        catch (IOException e) {
            logger.error("Hdi deployment returned with IOException.");
            throw new InternalError("Deployment returned an error");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isDeploymentFinished(String jobGuid) throws InternalError {
        URI statusUri;
        try {
            statusUri = new URL(this.dynamicDeploymentUrlStr + STATUS_PATH + jobGuid).toURI();
        }
        catch (MalformedURLException | URISyntaxException e) {
            logger.error("Wrong URL for HDI deployment specified: " + this.dynamicDeploymentUrlStr + STATUS_PATH + jobGuid);
            throw new InternalError("Wrong URL for HDI deployment specified: " + this.dynamicDeploymentUrlStr + STATUS_PATH + jobGuid, e);
        }
        try {
            Throwable throwable;
            CloseableHttpResponse response;
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            Throwable throwable2 = null;
            try {
                int responseCode;
                block39: {
                    DeploymentReturn deploymentReturn;
                    block40: {
                        boolean bl;
                        block41: {
                            HttpUriRequest getRequest = RequestBuilder.get((URI)statusUri).setHeader("Authorization", this.getAuthHeader()).setHeader("Accept", APPLICATION_JSON).setHeader("Content-Type", APPLICATION_JSON).build();
                            response = httpClient.execute(getRequest);
                            throwable = null;
                            responseCode = response.getStatusLine().getStatusCode();
                            if (responseCode != 200) break block39;
                            deploymentReturn = null;
                            if (response.getEntity() != null) {
                                deploymentReturn = new StreamToJsonConverter<DeploymentReturn>(DeploymentReturn.class).asJson(EntityUtils.toString((HttpEntity)response.getEntity()));
                            }
                            if (deploymentReturn == null || !"FINISHED".equalsIgnoreCase(deploymentReturn.status)) break block40;
                            if (deploymentReturn.exitCode == null || deploymentReturn.exitCode != 0) {
                                logger.error("HDI deployment failed");
                                this.writeDeployReturnIntoLog(deploymentReturn, true);
                                throw new InternalError("Deployer returned an error");
                            }
                            bl = true;
                            if (response == null) return bl;
                            if (throwable == null) break block41;
                            try {
                                response.close();
                                return bl;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                                return bl;
                            }
                        }
                        response.close();
                        return bl;
                    }
                    if (deploymentReturn == null) {
                        logger.error("Hdi deployment failed. It returned an empty payload");
                        throw new InternalError("Deployment returned an error");
                    }
                    boolean bl = false;
                    return bl;
                }
                try {
                    throw new InternalError("Deployment endpoint returned " + responseCode);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            {
                finally {
                    if (response != null) {
                        if (throwable != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                        } else {
                            response.close();
                        }
                    }
                }
            }
            finally {
                if (httpClient != null) {
                    if (throwable2 != null) {
                        try {
                            httpClient.close();
                        }
                        catch (Throwable throwable7) {
                            throwable2.addSuppressed(throwable7);
                        }
                    } else {
                        httpClient.close();
                    }
                }
            }
        }
        catch (IOException e) {
            logger.error("Hdi deployment returned with IOException.");
            throw new InternalError("Deployment returned an error");
        }
    }

    private void populateHdiContainerSync(DataSourceInfo dataSourceInfo, String tenantId) throws InternalError, HdiDeploymentCommunicationProblem {
        if (!FilterTenants.realTenants().test(tenantId)) {
            return;
        }
        try {
            Throwable throwable = null;
            try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();){
                int responseCode;
                Throwable throwable2;
                CloseableHttpResponse response;
                block31: {
                    block32: {
                        block33: {
                            HttpUriRequest postRequest = RequestBuilder.post((URI)this.dynamicDeployementUri).setHeader("Authorization", this.getAuthHeader()).setHeader("Accept", APPLICATION_JSON).setHeader("Content-Type", APPLICATION_JSON).setEntity((HttpEntity)new StringEntity(this.getBody(dataSourceInfo, tenantId, this.userProvidedSchemasExit.onCallDynamicHdiDeployment()))).build();
                            response = httpClient.execute(postRequest);
                            throwable2 = null;
                            responseCode = response.getStatusLine().getStatusCode();
                            if (responseCode != 200) break block31;
                            StreamToJsonConverter<DeploymentReturn> converter = new StreamToJsonConverter<DeploymentReturn>(DeploymentReturn.class);
                            DeploymentReturn deploymentReturn = null;
                            if (response.getEntity() != null) {
                                String payload = EntityUtils.toString((HttpEntity)response.getEntity());
                                deploymentReturn = converter.asJson(payload);
                            }
                            if (deploymentReturn != null && deploymentReturn.exitCode == -1) {
                                logger.error("Hdi deployment failed. It returned -1.");
                                this.writeDeployReturnIntoLog(deploymentReturn, true);
                                throw new HdiDeploymentCommunicationProblem("Deployment returned an error");
                            }
                            if (deploymentReturn == null || deploymentReturn.exitCode == null || deploymentReturn.exitCode != 0) {
                                logger.error("HDI deployment failed");
                                this.writeDeployReturnIntoLog(deploymentReturn, true);
                                throw new InternalError("Deployer returned an error");
                            }
                            logger.debug("HDI deployment succeeded");
                            this.writeDeployReturnIntoLog(deploymentReturn, false);
                            if (response == null) break block32;
                            if (throwable2 == null) break block33;
                            try {
                                response.close();
                            }
                            catch (Throwable throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            break block32;
                        }
                        response.close();
                    }
                    return;
                }
                try {
                    try {
                        try {
                            throw new HdiDeploymentCommunicationProblem("Deployment endpoint returned " + responseCode);
                        }
                        catch (Throwable throwable4) {
                            throwable2 = throwable4;
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (response != null) {
                            if (throwable2 != null) {
                                try {
                                    response.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable2.addSuppressed(throwable6);
                                }
                            } else {
                                response.close();
                            }
                        }
                        throw throwable5;
                    }
                }
                catch (Throwable throwable7) {
                    throwable = throwable7;
                    throw throwable7;
                }
            }
        }
        catch (IOException e) {
            logger.error("Hdi deployment returned with IOException {}.", (Object)e.getMessage());
            throw new HdiDeploymentCommunicationProblem("Deployment returned an error", e);
        }
    }

    protected String getBody(DataSourceInfo dataSourceInfo, String tenantId, List<UserProvidedSchema> userProvidedSchemas) throws InternalError {
        DeploymentPayload payload = new DeploymentPayload();
        DbHost[] dbHosts = new DbHost[]{new DbHost()};
        dbHosts[0].port = Integer.parseInt(dataSourceInfo.getPort());
        dbHosts[0].host = dataSourceInfo.getHost();
        Credentials credentials = new Credentials();
        credentials.schema = dataSourceInfo.getSchema();
        credentials.driver = dataSourceInfo.getDriver();
        credentials.port = dataSourceInfo.getPort();
        credentials.host = dataSourceInfo.getHost();
        credentials.db_hosts = dbHosts;
        credentials.user = dataSourceInfo.getUser();
        credentials.password = dataSourceInfo.getPassword();
        credentials.hdi_user = dataSourceInfo.getHdiUser();
        credentials.hdi_password = dataSourceInfo.getHdiPassword();
        credentials.url = dataSourceInfo.getUrl();
        credentials.certificate = dataSourceInfo.getCertificate();
        Hana[] hanas = new Hana[]{new Hana()};
        hanas[0].name = TARGET_CONTAINER_NAME;
        hanas[0].credentials = credentials;
        payload.ADDITIONAL_VCAP_SERVICES = new VcapService();
        payload.ADDITIONAL_VCAP_SERVICES.hana = hanas;
        if (userProvidedSchemas != null && userProvidedSchemas.size() > 0) {
            UserProvidedSchema[] userProvidedSchemaArray = new UserProvidedSchema[userProvidedSchemas.size()];
            userProvidedSchemas.toArray(userProvidedSchemaArray);
            payload.ADDITIONAL_VCAP_SERVICES.user_provided = userProvidedSchemaArray;
        }
        payload.TARGET_CONTAINER = TARGET_CONTAINER_NAME;
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.writeValueAsString((Object)payload);
        }
        catch (JsonProcessingException e) {
            logger.error("Could not create deployer payload " + e.getMessage());
            throw new InternalError(e);
        }
    }

    private String getBodyWithInstanceManagerBasedPayload(DataSourceInfo dataSourceInfo, String tenantId) throws InternalError {
        ImBasedCredentialsHdiDeployment credentials;
        ImBasedHdiDeploymentPayload payload = new ImBasedHdiDeploymentPayload();
        payload.credentials = credentials = new ImBasedCredentialsHdiDeployment();
        credentials.schema = dataSourceInfo.getSchema();
        credentials.driver = dataSourceInfo.getDriver();
        credentials.port = dataSourceInfo.getPort();
        credentials.host = dataSourceInfo.getHost();
        credentials.user = dataSourceInfo.getUser();
        credentials.password = dataSourceInfo.getPassword();
        credentials.hdi_user = dataSourceInfo.getHdiUser();
        credentials.hdi_password = dataSourceInfo.getHdiPassword();
        credentials.url = dataSourceInfo.getUrl();
        credentials.certificate = dataSourceInfo.getCertificate();
        payload.tenant_id = dataSourceInfo.getTenantId();
        payload.id = dataSourceInfo.getId();
        payload.status = dataSourceInfo.getStatusAsText();
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.writeValueAsString((Object)payload);
        }
        catch (JsonProcessingException e) {
            logger.error("Could not create deployer payload " + e.getMessage());
            throw new InternalError(e);
        }
    }

    private String getAuthHeader() throws InternalError {
        String auth = this.user + ":" + this.password;
        try {
            String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes("UTF-8"));
            return "Basic " + encodedAuth;
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Could not create encoded authorization header");
            throw new InternalError("Could not create encoded authorization header");
        }
    }

    private void writeDeployReturnIntoLog(DeploymentReturn deploymentReturn, Boolean isError) {
        if (deploymentReturn == null || deploymentReturn.messages == null) {
            if (isError.booleanValue()) {
                if (deploymentReturn == null) {
                    logger.error("Hdi deployment returned no payload");
                } else {
                    logger.error("Hdi deployment returned with exit code {}, but no return messages provided", (Object)deploymentReturn.exitCode);
                }
            }
            return;
        }
        if (isError.booleanValue()) {
            Arrays.stream(deploymentReturn.messages).filter(m -> "ERROR".equalsIgnoreCase(m.severity)).forEach(m -> logger.error("Path: {} .Message {} ", (Object)m.path, (Object)m.message));
        }
    }
}

