/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.sap.cloud.mt.subscription.DataSourceInfo;
import com.sap.cloud.mt.subscription.DataSourceInfoBuilder;
import com.sap.cloud.mt.subscription.DbIdentifiers;
import com.sap.cloud.mt.subscription.DbIdentifiersHana;
import com.sap.cloud.mt.subscription.FilterTenants;
import com.sap.cloud.mt.subscription.InstanceLifecycleManager;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.cloud.mt.subscription.exceptions.UnknownTenant;
import com.sap.xsa.core.instancemanager.client.ImClientException;
import com.sap.xsa.core.instancemanager.client.InstanceCreationOptions;
import com.sap.xsa.core.instancemanager.client.InstanceManagerClient;
import com.sap.xsa.core.instancemanager.client.ManagedServiceInstance;
import com.sap.xsa.core.instancemanager.client.OperationStatus;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceLifecycleManagerImpl
implements InstanceLifecycleManager {
    private static final Logger logger = LoggerFactory.getLogger(InstanceLifecycleManagerImpl.class);
    private final InstanceManagerClient instanceManagerClient;
    private final int timeout;
    private DbIdentifiers dbIdentifiers;

    public InstanceLifecycleManagerImpl(InstanceManagerClient instanceManagerClient, int timeout, DbIdentifiers dbIdentifiers) {
        this.instanceManagerClient = instanceManagerClient;
        this.timeout = timeout;
        this.dbIdentifiers = dbIdentifiers;
    }

    public InstanceLifecycleManagerImpl(InstanceManagerClient instanceManagerClient, int timeout) {
        this(instanceManagerClient, timeout, null);
    }

    @Override
    public void createNewInstance(String tenantId, InstanceCreationOptions instanceCreationOptions) throws InternalError {
        String databaseId;
        if (instanceCreationOptions != null && instanceCreationOptions.getProvisioningParameters() != null && (databaseId = (String)instanceCreationOptions.getProvisioningParameters().get("database_id")) != null) {
            logger.debug("Using database id {}", (Object)databaseId);
        }
        try {
            this.instanceManagerClient.createManagedInstance(tenantId, instanceCreationOptions, this.timeout);
        }
        catch (ImClientException e) {
            logger.error("Could not create HDI container. Error is: {}", (Object)e.getMessage());
            throw new InternalError(e);
        }
    }

    @Override
    public void deleteInstance(String tenantId) throws InternalError {
        try {
            this.checkThatTenantExists(tenantId);
        }
        catch (UnknownTenant unknownTenant) {
            logger.warn("No HDI container for tenant {} found", (Object)tenantId);
            return;
        }
        try {
            this.instanceManagerClient.deleteManagedInstance(tenantId, this.timeout);
        }
        catch (ImClientException e) {
            logger.error("Could not delete HDI container. Error is: {}", (Object)e.getMessage());
            throw new InternalError(e);
        }
    }

    @Override
    public DataSourceInfo getDataSourceInfo(String tenantId, boolean forceCacheUpdate) throws InternalError, UnknownTenant {
        ManagedServiceInstance instance = null;
        try {
            instance = this.instanceManagerClient.getManagedInstance(tenantId, forceCacheUpdate);
            if (instance == null) {
                throw new UnknownTenant("Tenant [" + tenantId + "] is not known");
            }
        }
        catch (ImClientException e) {
            logger.error("Could not get HDI container information. Error is: {}", (Object)e.getMessage());
            throw new UnknownTenant("Tenant [" + tenantId + "] is not known");
        }
        if (this.getContainerStatus(instance.getStatus()) != InstanceLifecycleManager.ContainerStatus.OK) {
            logger.error("Database for tenant {} has a wrong status {}", (Object)tenantId, (Object)instance.getStatus());
            throw new InternalError("Database for tenant " + tenantId + " has a wrong status " + instance.getStatus());
        }
        return DataSourceInfoBuilder.createBuilder().host((String)instance.getCredentials().get("host")).port((String)instance.getCredentials().get("port")).driver((String)instance.getCredentials().get("driver")).url((String)instance.getCredentials().get("url")).schema((String)instance.getCredentials().get("schema")).hdiUser((String)instance.getCredentials().get("hdi_user")).hdiPassword((String)instance.getCredentials().get("hdi_password")).user((String)instance.getCredentials().get("user")).password((String)instance.getCredentials().get("password")).certificate((String)instance.getCredentials().get("certificate")).tenantId(tenantId).id(instance.getId()).statusAsText(instance.getStatus().toString()).dbKey(this.createDbKey((String)instance.getCredentials().get("host"), (String)instance.getCredentials().get("port"))).build();
    }

    @Override
    public InstanceLifecycleManager.ContainerStatus getContainerStatus(String tenantId) throws InternalError {
        try {
            ManagedServiceInstance instance = this.instanceManagerClient.getManagedInstance(tenantId, true);
            if (instance == null) {
                return InstanceLifecycleManager.ContainerStatus.DOES_NOT_EXIST;
            }
            OperationStatus status = instance.getStatus();
            return this.getContainerStatus(status);
        }
        catch (ImClientException e) {
            throw new InternalError(e);
        }
    }

    private InstanceLifecycleManager.ContainerStatus getContainerStatus(OperationStatus status) throws InternalError {
        switch (status) {
            case CREATION_SUCCEEDED: 
            case UPDATE_SUCCEEDED: 
            case UPDATE_FAILED: {
                return InstanceLifecycleManager.ContainerStatus.OK;
            }
            case CREATION_IN_PROGRESS: 
            case UPDATE_IN_PROGRESS: 
            case DELETION_IN_PROGRESS: {
                return InstanceLifecycleManager.ContainerStatus.IN_PROGRESS;
            }
            case DELETION_FAILED: {
                return InstanceLifecycleManager.ContainerStatus.ERRONEOUS;
            }
            case CREATION_FAILED: {
                return InstanceLifecycleManager.ContainerStatus.CREATION_ERROR;
            }
        }
        logger.error("Undefined status {}", (Object)status);
        throw new InternalError("Unknown status");
    }

    @Override
    public Set<String> getAllTenants() throws InternalError {
        List instances = null;
        try {
            instances = this.instanceManagerClient.getManagedInstances();
        }
        catch (ImClientException e) {
            logger.error("Could not get list of HDI containers. Error is: {}", (Object)e.getMessage());
            throw new InternalError(e);
        }
        return instances.stream().filter(i -> {
            try {
                return this.getContainerStatus(i.getStatus()) == InstanceLifecycleManager.ContainerStatus.OK;
            }
            catch (InternalError internalError) {
                return false;
            }
        }).map(i -> i.getId()).filter(FilterTenants.realTenants()).collect(Collectors.toSet());
    }

    @Override
    public void checkThatTenantExists(String tenantId) throws UnknownTenant {
        try {
            ManagedServiceInstance instance = this.instanceManagerClient.getManagedInstance(tenantId, true);
            if (instance == null) {
                throw new UnknownTenant("Tenant " + tenantId + " is not known");
            }
        }
        catch (ImClientException e) {
            throw new UnknownTenant(e, "Tenant " + tenantId + " is not known");
        }
    }

    @Override
    public List<DataSourceInfo> createAndGetLibContainers() throws InternalError {
        if (this.dbIdentifiers == null) {
            return new ArrayList<DataSourceInfo>();
        }
        if (!(this.dbIdentifiers instanceof DbIdentifiersHana)) {
            throw new InternalError("No Hana DB identifiers specified");
        }
        Set<String> dbIds = ((DbIdentifiersHana)this.dbIdentifiers).getDbIds();
        try {
            this.getMissing(dbIds).stream().forEach(id -> {
                try {
                    this.createNewInstance(this.getMtLibContainerName((String)id), this.createInstanceCreationOptions((String)id));
                }
                catch (InternalError internalError) {
                    // empty catch block
                }
            });
            return dbIds.stream().map(id -> {
                try {
                    return this.getDataSourceInfo(this.getMtLibContainerName((String)id), false);
                }
                catch (InternalError | UnknownTenant error) {
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (ImClientException e) {
            logger.error("Could not access instance or service manager. Error is: {}", (Object)e.getMessage());
            throw new InternalError(e);
        }
    }

    private Set<String> getMissing(Set<String> dbIds) throws ImClientException {
        List instances = this.instanceManagerClient.getManagedInstances();
        HashSet createdLibTenants = instances.stream().filter(i -> i.getId().startsWith("MT_LIB_TENANT-")).map(i -> i.getId().substring("MT_LIB_TENANT-".length()).toLowerCase(Locale.ENGLISH)).collect(Collectors.toCollection(HashSet::new));
        return dbIds.stream().filter(id -> !createdLibTenants.contains(id.toLowerCase(Locale.ENGLISH))).collect(Collectors.toSet());
    }

    @Override
    public DbIdentifiers getDbIdentifiers() {
        return this.dbIdentifiers.createCopy();
    }

    @Override
    public boolean hasDbIdentifiers() {
        return this.dbIdentifiers != null && this.dbIdentifiers.areSet();
    }

    @Override
    public void setDbIdentifiers(DbIdentifiers dbIdentifiers) {
        this.dbIdentifiers = dbIdentifiers;
    }

    private String createDbKey(String host, String port) {
        return host + ":" + port;
    }
}

