/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cloud.mt.subscription.ClientCredentialJwtAccess;
import com.sap.cloud.mt.subscription.ClientCredentialJwtReaderIntf;
import com.sap.cloud.mt.subscription.exceptions.CommunicationError;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.cloud.mt.subscription.json.SaasCallBackPayload;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaasRegistry {
    private static final String APPLICATION_JSON = "application/json";
    public static final String SUCCEEDED = "SUCCEEDED";
    public static final String FAILED = "FAILED";
    private final ClientCredentialJwtAccess jwtAccess;
    private final String saasRegistryUrl;
    private static final String AUTHENTIFICATION_SCHEME = "Bearer";
    private static final Logger logger = LoggerFactory.getLogger(SaasRegistry.class);

    public SaasRegistry(ClientCredentialJwtReaderIntf jwtReader, String saasRegistryUrl) {
        this.jwtAccess = new ClientCredentialJwtAccess(jwtReader);
        this.saasRegistryUrl = saasRegistryUrl;
    }

    public void callBackSaasRegistry(boolean success, String message, String subscriptionUrl, String callbackUrl) throws InternalError {
        String completeUrl = this.saasRegistryUrl + callbackUrl;
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();){
            SaasCallBackPayload payload = new SaasCallBackPayload();
            payload.message = message;
            payload.status = success ? SUCCEEDED : FAILED;
            payload.subscriptionUrl = subscriptionUrl;
            ObjectMapper objectMapper = new ObjectMapper();
            String jsonAsStr = objectMapper.writeValueAsString((Object)payload);
            StringEntity entity = new StringEntity(jsonAsStr, ContentType.APPLICATION_JSON);
            String jwt = this.jwtAccess.getJwt();
            if (jwt == null || jwt.isEmpty()) {
                throw new InternalError("Could not call saas registry as jwt is empty");
            }
            logger.debug("Call saas registry at url {}", (Object)completeUrl);
            HttpUriRequest putRequest = RequestBuilder.put((URI)new URL(completeUrl).toURI()).setHeader("Authorization", "Bearer " + jwt).setHeader("Accept", APPLICATION_JSON).setHeader("Content-Type", APPLICATION_JSON).setEntity((HttpEntity)entity).build();
            try (CloseableHttpResponse response = httpClient.execute(putRequest);){
                int responseCode = response.getStatusLine().getStatusCode();
                logger.debug("Saas registry returned response code {}", (Object)responseCode);
                if (responseCode != 200) {
                    throw new InternalError("Saas registry returned http status " + responseCode + " . Called saas registry url is " + completeUrl);
                }
            }
        }
        catch (URISyntaxException e) {
            throw new InternalError("Saas registry url " + callbackUrl + " has wrong format  . Called saas registry url is " + completeUrl, e);
        }
        catch (CommunicationError | IOException e) {
            throw new InternalError("Could not call saas registry. Reason is " + e.getMessage() + " . Called saas registry url is " + completeUrl, e);
        }
    }
}

