/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.sap.cloud.mt.subscription.DbDeployerLiquibase;
import com.sap.cloud.mt.subscription.DynamicHdiDeploymentParameters;
import com.sap.cloud.mt.subscription.HdiContainerManager;
import com.sap.cloud.mt.subscription.InstanceLifecycleManager;
import com.sap.cloud.mt.subscription.LiquibaseResourceAccessor;
import com.sap.cloud.mt.subscription.SaasRegistry;
import com.sap.cloud.mt.subscription.SecurityChecker;
import com.sap.cloud.mt.subscription.Subscriber;
import com.sap.cloud.mt.subscription.SubscriberImpl;
import com.sap.cloud.mt.subscription.SubscriberSidecarImpl;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.cloud.mt.subscription.exits.Exits;
import java.time.Duration;
import org.apache.commons.lang3.StringUtils;

public class SubscriberBuilder {
    private String sideCarUrl;
    private String baseUiUrl;
    private String urlSeparator;
    private Exits exits;
    private SecurityChecker securityChecker;
    private SaasRegistry saasRegistry;
    private InstanceLifecycleManager instanceLifecycleManager;
    private DynamicHdiDeploymentParameters hdiDeploymentParas;
    private String liquibaseFileName;
    private String liquibaseContexts;
    private LiquibaseResourceAccessor liquibaseResourceAccessor;
    private int maxRetries;
    private Duration retryWaitTime;

    private SubscriberBuilder() {
    }

    public static SubscriberBuilder create() {
        return new SubscriberBuilder();
    }

    public Subscriber build() throws InternalError {
        if (!StringUtils.isEmpty((CharSequence)this.sideCarUrl)) {
            return SubscriberSidecarImpl.SubscriberSidecarImplBuilder.create().sidecarUrl(this.sideCarUrl).baseUiUrl(this.baseUiUrl).urlSeparator(this.urlSeparator).exits(this.exits).securityChecker(this.securityChecker).saasRegistry(this.saasRegistry).maxRetries(this.maxRetries).retryWaitTime(this.retryWaitTime).build();
        }
        if (this.hdiDeploymentParas != null && !StringUtils.isEmpty((CharSequence)this.hdiDeploymentParas.getDynamicDbDeploymentUrl())) {
            HdiContainerManager dbDeployer = new HdiContainerManager(this.hdiDeploymentParas.getDynamicDbDeploymentUrl(), this.hdiDeploymentParas.getDynamicDbDeploymentUser(), this.hdiDeploymentParas.getDynamicDbDeploymentPassword(), this.hdiDeploymentParas.getMaxAsyncDeployWaitTimeSeconds(), this.hdiDeploymentParas.getAsyncDeployPollTimeSeconds(), this.exits.getUserProvidedSchemasExit());
            return new SubscriberImpl(this.instanceLifecycleManager, dbDeployer, this.baseUiUrl, this.urlSeparator, this.exits, this.securityChecker, this.saasRegistry);
        }
        if (!StringUtils.isEmpty((CharSequence)this.liquibaseFileName) || this.liquibaseResourceAccessor != null) {
            DbDeployerLiquibase dbDeployer = new DbDeployerLiquibase(this.liquibaseResourceAccessor, this.liquibaseFileName, this.liquibaseContexts);
            return new SubscriberImpl(this.instanceLifecycleManager, dbDeployer, this.baseUiUrl, this.urlSeparator, this.exits, this.securityChecker, this.saasRegistry);
        }
        throw new InternalError("Could not create subscriber");
    }

    public SubscriberBuilder sideCarUrl(String sideCarUrl) {
        this.sideCarUrl = sideCarUrl;
        return this;
    }

    public SubscriberBuilder baseUiUrl(String baseUiUrl) {
        this.baseUiUrl = baseUiUrl;
        return this;
    }

    public SubscriberBuilder urlSeparator(String urlSeparator) {
        this.urlSeparator = urlSeparator;
        return this;
    }

    public SubscriberBuilder exits(Exits exits) {
        this.exits = exits;
        return this;
    }

    public SubscriberBuilder securityChecker(SecurityChecker securityChecker) {
        this.securityChecker = securityChecker;
        return this;
    }

    public SubscriberBuilder saasRegistry(SaasRegistry saasRegistry) {
        this.saasRegistry = saasRegistry;
        return this;
    }

    public SubscriberBuilder instanceLifecycleManager(InstanceLifecycleManager instanceLifecycleManager) {
        this.instanceLifecycleManager = instanceLifecycleManager;
        return this;
    }

    public SubscriberBuilder hdiDeploymentParas(DynamicHdiDeploymentParameters hdiDeploymentParas) {
        this.hdiDeploymentParas = hdiDeploymentParas;
        return this;
    }

    public SubscriberBuilder liquibaseFileName(String liquibaseFileName) {
        this.liquibaseFileName = liquibaseFileName;
        return this;
    }

    public SubscriberBuilder liquibaseContexts(String liquibaseContexts) {
        this.liquibaseContexts = liquibaseContexts;
        return this;
    }

    public SubscriberBuilder liquibaseResourceAccessor(LiquibaseResourceAccessor liquibaseResourceAccessor) {
        this.liquibaseResourceAccessor = liquibaseResourceAccessor;
        return this;
    }

    public SubscriberBuilder maxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    public SubscriberBuilder retryWaitTime(Duration retryWaitTime) {
        this.retryWaitTime = retryWaitTime;
        return this;
    }
}

