/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cloud.mt.subscription.FilterTenants;
import com.sap.cloud.mt.subscription.exceptions.ParameterError;

public class Tools {
    public static final String SECURE_CHARS = "^[_a-zA-Z0-9\\-]+$";
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static void checkExternalTenantId(String tenantId) throws ParameterError {
        if (!FilterTenants.realTenants().test(tenantId)) {
            throw new ParameterError("Tenant Id is identical to a technical container");
        }
        Tools.checkTenantIdCharacters(tenantId);
    }

    public static void checkTenantIdCharacters(String tenantId) throws ParameterError {
        if (!tenantId.matches(SECURE_CHARS)) {
            throw new ParameterError("Tenant id contains forbidden characters");
        }
    }

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }
}

