/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.tools;

import java.time.Duration;
import java.util.function.Supplier;

public class Wait {
    private final Duration maximumTime;
    private final Duration waitTime;

    private Wait(Duration maximumTime, Duration waitTime) {
        this.maximumTime = maximumTime;
        this.waitTime = waitTime;
    }

    public static WaitBuilder createBuilder() {
        return WaitBuilder.create();
    }

    public void waitUntil(Supplier<Boolean> until) {
        long startTime = System.currentTimeMillis();
        if (until.get().booleanValue()) {
            return;
        }
        do {
            try {
                Thread.sleep(this.waitTime.toMillis());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        } while (!until.get().booleanValue() && System.currentTimeMillis() - startTime <= this.maximumTime.toMillis());
    }

    public static final class WaitBuilder {
        private Duration maximumTime;
        private Duration waitTime;

        private WaitBuilder() {
        }

        private static WaitBuilder create() {
            return new WaitBuilder();
        }

        public WaitBuilder maximumTime(Duration maximumTime) {
            this.maximumTime = maximumTime;
            return this;
        }

        public WaitBuilder waitTime(Duration waitTime) {
            this.waitTime = waitTime;
            return this;
        }

        public Wait build() {
            return new Wait(this.maximumTime, this.waitTime);
        }
    }
}

