/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.sap.cloud.mt.subscription.DbCredentials;
import com.sap.cloud.mt.subscription.DbIdentifiers;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class DbIdentifiersSql
implements DbIdentifiers {
    private final List<DbCredentials> credentials;

    public DbIdentifiersSql(List<DbCredentials> credentials) {
        this.credentials = credentials;
    }

    public DbIdentifiersSql(DbIdentifiersSql dbIdentifiersSql) {
        this.credentials = new ArrayList<DbCredentials>();
        dbIdentifiersSql.credentials.stream().forEach(c -> this.credentials.add(c.createCopy()));
    }

    @Override
    public boolean areSet() {
        return this.credentials != null && !this.credentials.isEmpty();
    }

    @Override
    public DbIdentifiers.DB getDB() {
        if (!this.credentials.isEmpty()) {
            return this.credentials.get(0).getDB();
        }
        return DbIdentifiers.DB.NONE;
    }

    public Optional<DbCredentials> getCredentials(String databaseId) {
        return this.credentials.stream().filter(c -> c.getDatabaseId().equals(databaseId)).findFirst();
    }

    public Optional<DbCredentials> getLast() {
        if (this.credentials == null || this.credentials.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.credentials.get(this.credentials.size() - 1));
    }

    public Stream<DbCredentials> asStream() {
        return this.credentials.stream();
    }

    @Override
    public DbIdentifiers createCopy() {
        return new DbIdentifiersSql(this);
    }
}

