/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.sap.cloud.mt.subscription.DbCredentials;
import com.sap.cloud.mt.subscription.DbCredentialsBuilder;
import com.sap.cloud.mt.subscription.DbIdentifiers;
import com.sap.cloud.mt.subscription.DbIdentifiersHana;
import com.sap.cloud.mt.subscription.DbIdentifiersSql;
import com.sap.cloud.mt.subscription.InstanceLifecycleManager;
import com.sap.cloud.mt.subscription.InstanceLifecycleManagerImpl;
import com.sap.cloud.mt.subscription.InstanceLifecycleManagerSqlDb;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.xsa.core.instancemanager.client.InstanceManagerClient;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class InstanceLifecycleManagerBuilder {
    private InstanceManagerClient instanceManagerClient;
    private DbIdentifiers dbIdentifiers;
    private int timeout = -1;
    private List<DbCredentials> dbCredentialsList = new ArrayList<DbCredentials>();
    private DbIdentifiers.DB db = DbIdentifiers.DB.NONE;

    public InstanceLifecycleManager build() throws InternalError {
        if (this.instanceManagerClient != null) {
            if (this.dbIdentifiers != null && !(this.dbIdentifiers instanceof DbIdentifiersHana)) {
                throw new InternalError("Hana database specified with database identifiers of non-HANA DB");
            }
            if (this.dbIdentifiers == null) {
                this.dbIdentifiers = new DbIdentifiersHana(new HashSet<String>());
            }
            return new InstanceLifecycleManagerImpl(this.instanceManagerClient, this.timeout, (DbIdentifiersHana)this.dbIdentifiers);
        }
        if (this.dbIdentifiers != null) {
            if (this.dbIdentifiers instanceof DbIdentifiersSql) {
                return new InstanceLifecycleManagerSqlDb((DbIdentifiersSql)this.dbIdentifiers);
            }
            throw new InternalError("No database credentials provided");
        }
        if (!this.dbCredentialsList.isEmpty()) {
            if (this.db == DbIdentifiers.DB.NONE) {
                throw new InternalError("No database type set");
            }
            return new InstanceLifecycleManagerSqlDb(new DbIdentifiersSql(this.dbCredentialsList));
        }
        throw new InternalError("No instance manager, service manager or databases specified");
    }

    public static InstanceLifecycleManagerBuilder create() {
        return new InstanceLifecycleManagerBuilder();
    }

    private InstanceLifecycleManagerBuilder() {
    }

    public InstanceLifecycleManagerBuilder instanceManagerClient(InstanceManagerClient instanceManagerClient) {
        this.instanceManagerClient = instanceManagerClient;
        return this;
    }

    public InstanceLifecycleManagerBuilder dbIdentifiers(DbIdentifiers dbIdentifiers) {
        this.dbIdentifiers = dbIdentifiers;
        return this;
    }

    public InstanceLifecycleManagerBuilder timeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public InstanceLifecycleManagerBuilder addDbCredentials(Map<String, Object> credentials) throws InternalError {
        return this.addDbCredentials(DbIdentifiers.DB.NONE, credentials);
    }

    public InstanceLifecycleManagerBuilder addDbCredentials(DbIdentifiers.DB db, Map<String, Object> credentials) throws InternalError {
        DbCredentialsBuilder dbCredentialsBuilder = DbCredentialsBuilder.create().db(db).credentials(credentials);
        DbCredentials dbCredentials = dbCredentialsBuilder.build();
        this.dbCredentialsList.add(dbCredentials);
        if (this.db != DbIdentifiers.DB.NONE && this.db != dbCredentials.getDB()) {
            throw new InternalError("It is not possible to combine different types of databases for multi tenancy");
        }
        if (this.db == DbIdentifiers.DB.NONE) {
            this.db = dbCredentials.getDB();
        }
        return this;
    }
}

