/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.sap.cloud.mt.subscription.DataSourceInfo;
import com.sap.cloud.mt.subscription.DataSourceInfoBuilder;
import com.sap.cloud.mt.subscription.DbIdentifiers;
import com.sap.cloud.mt.subscription.DbIdentifiersHana;
import com.sap.cloud.mt.subscription.FilterTenants;
import com.sap.cloud.mt.subscription.InstanceLifecycleManager;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.cloud.mt.subscription.exceptions.UnknownTenant;
import com.sap.cloud.mt.tools.api.UuidChecker;
import com.sap.xsa.core.instancemanager.client.GetOptions;
import com.sap.xsa.core.instancemanager.client.ImClientException;
import com.sap.xsa.core.instancemanager.client.InstanceCreationOptions;
import com.sap.xsa.core.instancemanager.client.InstanceManagerClient;
import com.sap.xsa.core.instancemanager.client.ManagedServiceInstance;
import com.sap.xsa.core.instancemanager.client.OperationStatus;
import com.sap.xsa.core.instancemanager.client.ServiceManagerClient;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceLifecycleManagerImpl
implements InstanceLifecycleManager {
    private static final Logger logger = LoggerFactory.getLogger(InstanceLifecycleManagerImpl.class);
    private static final String HOST = "host";
    private final InstanceManagerClient instanceManagerClient;
    private final ServiceManagerClient serviceManagerClient;
    private final int timeout;
    private final DbIdentifiersProxy dbIdentifiersProxy = new DbIdentifiersProxy();
    private final AtomicBoolean isInitialized = new AtomicBoolean(false);

    public InstanceLifecycleManagerImpl(InstanceManagerClient instanceManagerClient, int timeout, DbIdentifiersHana dbIdentifiers, boolean synchronousInit) {
        this.instanceManagerClient = instanceManagerClient;
        this.serviceManagerClient = instanceManagerClient instanceof ServiceManagerClient ? (ServiceManagerClient)instanceManagerClient : null;
        this.timeout = timeout;
        if (dbIdentifiers != null) {
            dbIdentifiers.getDbIds().stream().forEach(this.dbIdentifiersProxy::add);
        }
        this.initOnce(synchronousInit);
    }

    public InstanceLifecycleManagerImpl(InstanceManagerClient instanceManagerClient, int timeout, DbIdentifiersHana dbIdentifiers) {
        this(instanceManagerClient, timeout, dbIdentifiers, false);
    }

    public InstanceLifecycleManagerImpl(InstanceManagerClient instanceManagerClient, int timeout) {
        this(instanceManagerClient, timeout, null);
    }

    private void initOnce(boolean synchronousInit) {
        if (!this.isInitialized.get()) {
            if (synchronousInit) {
                this.fillCache();
            } else {
                Executors.newSingleThreadExecutor().execute(this::fillCache);
            }
        }
    }

    private synchronized void fillCache() {
        try {
            this.instanceManagerClient.getManagedInstances();
            this.isInitialized.set(true);
        }
        catch (ImClientException e) {
            logger.error("Could not fill cache of instance manager client lib", (Throwable)e);
        }
    }

    @Override
    public void createNewInstance(String tenantId, InstanceCreationOptions instanceCreationOptions) throws InternalError {
        String databaseId;
        if (instanceCreationOptions != null && instanceCreationOptions.getProvisioningParameters() != null && (databaseId = (String)instanceCreationOptions.getProvisioningParameters().get("database_id")) != null) {
            logger.debug("Using database id {}", (Object)databaseId);
        }
        try {
            this.instanceManagerClient.createManagedInstance(tenantId, instanceCreationOptions, this.timeout);
        }
        catch (ImClientException e) {
            throw new InternalError(e);
        }
    }

    @Override
    public void deleteInstance(String tenantId) throws InternalError {
        try {
            this.checkThatTenantExists(tenantId);
        }
        catch (UnknownTenant unknownTenant) {
            logger.warn("No HDI container for tenant {} found", (Object)tenantId);
            return;
        }
        try {
            this.instanceManagerClient.deleteManagedInstance(tenantId, this.timeout);
        }
        catch (ImClientException e) {
            throw new InternalError(e);
        }
    }

    @Override
    public DataSourceInfo getDataSourceInfo(String tenantId, boolean forceCacheUpdate) throws InternalError, UnknownTenant {
        ManagedServiceInstance instance = null;
        try {
            instance = this.instanceManagerClient.getManagedInstance(tenantId, forceCacheUpdate);
            if (instance == null) {
                throw new UnknownTenant("Tenant [" + tenantId + "] is not known");
            }
        }
        catch (ImClientException e) {
            throw new UnknownTenant(e, "Tenant [" + tenantId + "] is not known");
        }
        if (this.getContainerStatus(instance.getStatus()) != InstanceLifecycleManager.ContainerStatus.OK) {
            logger.error("Database for tenant {} has a wrong status {}", (Object)tenantId, (Object)instance.getStatus());
            throw new InternalError("Database for tenant " + tenantId + " has a wrong status " + instance.getStatus());
        }
        return DataSourceInfoBuilder.createBuilder().host((String)instance.getCredentials().get(HOST)).port((String)instance.getCredentials().get("port")).driver((String)instance.getCredentials().get("driver")).url((String)instance.getCredentials().get("url")).schema((String)instance.getCredentials().get("schema")).hdiUser((String)instance.getCredentials().get("hdi_user")).hdiPassword((String)instance.getCredentials().get("hdi_password")).user((String)instance.getCredentials().get("user")).password((String)instance.getCredentials().get("password")).certificate((String)instance.getCredentials().get("certificate")).tenantId(tenantId).id(instance.getId()).statusAsText(instance.getStatus().toString()).dbKey(this.createDbKey((String)instance.getCredentials().get(HOST), (String)instance.getCredentials().get("port"))).build();
    }

    @Override
    public InstanceLifecycleManager.ContainerStatus getContainerStatus(String tenantId) throws InternalError {
        try {
            ManagedServiceInstance instance = this.instanceManagerClient.getManagedInstance(tenantId, true);
            if (instance == null) {
                return InstanceLifecycleManager.ContainerStatus.DOES_NOT_EXIST;
            }
            OperationStatus status = instance.getStatus();
            return this.getContainerStatus(status);
        }
        catch (ImClientException e) {
            throw new InternalError(e);
        }
    }

    private InstanceLifecycleManager.ContainerStatus getContainerStatus(OperationStatus status) throws InternalError {
        switch (status) {
            case CREATION_SUCCEEDED: 
            case UPDATE_SUCCEEDED: 
            case UPDATE_FAILED: {
                return InstanceLifecycleManager.ContainerStatus.OK;
            }
            case CREATION_IN_PROGRESS: 
            case UPDATE_IN_PROGRESS: 
            case DELETION_IN_PROGRESS: {
                return InstanceLifecycleManager.ContainerStatus.IN_PROGRESS;
            }
            case DELETION_FAILED: {
                return InstanceLifecycleManager.ContainerStatus.ERRONEOUS;
            }
            case CREATION_FAILED: {
                return InstanceLifecycleManager.ContainerStatus.CREATION_ERROR;
            }
        }
        logger.error("Undefined status {}", (Object)status);
        throw new InternalError("Unknown status");
    }

    @Override
    public Set<String> getAllTenants(boolean forceCacheUpdate) throws InternalError {
        List instances = null;
        try {
            instances = this.serviceManagerClient != null ? (forceCacheUpdate ? this.serviceManagerClient.getManagedInstances() : this.serviceManagerClient.getManagedInstances(this.noCacheUpdateNoServiceBindings())) : this.instanceManagerClient.getManagedInstances();
        }
        catch (ImClientException e) {
            throw new InternalError(e);
        }
        return instances.stream().filter(i -> {
            try {
                return this.getContainerStatus(i.getStatus()) == InstanceLifecycleManager.ContainerStatus.OK;
            }
            catch (InternalError internalError) {
                return false;
            }
        }).map(ManagedServiceInstance::getId).filter(FilterTenants.realTenants()).collect(Collectors.toSet());
    }

    @Override
    public void checkThatTenantExists(String tenantId) throws UnknownTenant, InternalError {
        try {
            ManagedServiceInstance instance = this.instanceManagerClient.getManagedInstance(tenantId, true);
            if (instance == null) {
                throw new UnknownTenant("Tenant " + tenantId + " is not known");
            }
        }
        catch (ImClientException e) {
            throw new InternalError("Instance manager client lib reports an error", e);
        }
    }

    @Override
    public List<DataSourceInfo> createAndGetLibContainers(DataSourceInfo dataSourceInfo) throws InternalError {
        String databaseId = null;
        if (dataSourceInfo != null) {
            databaseId = this.getDatabaseId(Collections.singletonMap(HOST, dataSourceInfo.getHost()));
        }
        Set<String> missingLibContainersDbIds = new HashSet<String>();
        if (databaseId != null) {
            if (this.isLibContainerMissing(databaseId)) {
                missingLibContainersDbIds.add(databaseId);
            }
        } else {
            missingLibContainersDbIds = this.getMissingLibContainers(this.dbIdentifiersProxy.getDbIds());
        }
        missingLibContainersDbIds.stream().forEach(id -> {
            try {
                logger.debug("Create new mt-lib container for database {}", id);
                this.createNewInstance(this.getMtLibContainerName((String)id), this.createInstanceCreationOptions((String)id));
            }
            catch (InternalError internalError) {
                logger.debug("Could not create new mt-lib container for database {} because of {} ", id, (Object)internalError.getMessage());
            }
        });
        return this.dbIdentifiersProxy.getDbIds().stream().map(id -> {
            try {
                return this.getDataSourceInfo(this.getMtLibContainerName((String)id), false);
            }
            catch (InternalError | UnknownTenant error) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Set<String> getMissingLibContainers(Set<String> dbIds) {
        return dbIds.stream().filter(this::isLibContainerMissing).collect(Collectors.toSet());
    }

    private boolean isLibContainerMissing(String dbId) {
        try {
            return this.instanceManagerClient.getManagedInstance(this.getMtLibContainerName(dbId)) == null;
        }
        catch (ImClientException e) {
            return true;
        }
    }

    private DbIdentifiers getDbIdentifiers() {
        return this.dbIdentifiersProxy.createCopy();
    }

    @Override
    public boolean hasDbIdentifiers() {
        return this.dbIdentifiersProxy.areSet();
    }

    @Override
    public void insertDbIdentifiers(DbIdentifiers dbIdentifiers) {
        ((DbIdentifiersHana)dbIdentifiers).getDbIds().stream().forEach(this.dbIdentifiersProxy::add);
    }

    @Override
    public DbIdentifiers.DB getDbType() {
        return this.dbIdentifiersProxy.getDbType();
    }

    private String createDbKey(String host, String port) {
        return host + ":" + port;
    }

    private GetOptions noCacheUpdateNoServiceBindings() {
        GetOptions getOptions = new GetOptions();
        getOptions.setForceCacheUpdate(false);
        getOptions.setCreateBindingIfMissing(false);
        return getOptions;
    }

    private String getDatabaseId(Map<String, Object> credentials) {
        String databaseId = StringUtils.substringBefore((String)((String)credentials.get(HOST)), (String)".");
        return UuidChecker.isUUId((String)databaseId) ? databaseId : null;
    }

    private class DbIdentifiersProxy {
        private final DbIdentifiersHana dbIdentifiers = new DbIdentifiersHana(new HashSet<String>());

        private DbIdentifiersProxy() {
        }

        public void add(String dbId) {
            this.dbIdentifiers.add(dbId);
        }

        public DbIdentifiers.DB getDbType() {
            return this.dbIdentifiers.getDB();
        }

        public boolean areSet() {
            this.prepare();
            return this.dbIdentifiers.areSet();
        }

        public DbIdentifiers createCopy() {
            this.prepare();
            return this.dbIdentifiers.createCopy();
        }

        public Set<String> getDbIds() {
            this.prepare();
            return this.dbIdentifiers.getDbIds();
        }

        private void prepare() {
            InstanceLifecycleManagerImpl.this.initOnce(true);
            try {
                this.updateDbIdentifiers();
            }
            catch (InternalError e) {
                logger.error("Could not determine db identifiers", (Throwable)e);
            }
        }

        private synchronized void updateDbIdentifiers() throws InternalError {
            try {
                List instances = InstanceLifecycleManagerImpl.this.instanceManagerClient instanceof ServiceManagerClient ? ((ServiceManagerClient)InstanceLifecycleManagerImpl.this.instanceManagerClient).getManagedInstances(InstanceLifecycleManagerImpl.this.noCacheUpdateNoServiceBindings()) : InstanceLifecycleManagerImpl.this.instanceManagerClient.getManagedInstances();
                instances.stream().map(ManagedServiceInstance::getCredentials).filter(Objects::nonNull).map(x$0 -> InstanceLifecycleManagerImpl.this.getDatabaseId(x$0)).filter(Objects::nonNull).map(Object::toString).forEach(this::add);
            }
            catch (ImClientException e) {
                throw new InternalError(e);
            }
        }
    }
}

