/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.sap.cloud.mt.subscription.MtxExecutionStatus;
import com.sap.cloud.mt.subscription.PollingParameters;
import com.sap.cloud.mt.subscription.SecurityChecker;
import com.sap.cloud.mt.subscription.Tools;
import com.sap.cloud.mt.subscription.exceptions.AuthorityError;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.cloud.mt.subscription.exceptions.NotFound;
import com.sap.cloud.mt.subscription.exceptions.ParameterError;
import com.sap.cloud.mt.subscription.exits.SubscribeExit;
import com.sap.cloud.mt.subscription.exits.UnSubscribeExit;
import com.sap.cloud.mt.subscription.json.DeletePayload;
import com.sap.cloud.mt.subscription.json.SubscriptionPayload;
import com.sap.cloud.mt.tools.api.AsyncCallResult;
import com.sap.cloud.mt.tools.api.ServiceResponse;
import com.sap.cloud.mt.tools.exception.InternalException;
import com.sap.xsa.core.instancemanager.client.InstanceCreationOptions;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MtxTools {
    public static final Duration SAAS_REGISTRY_WAIT_TIME = Duration.ofMillis(20L);
    private static Logger logger = LoggerFactory.getLogger(MtxTools.class);
    private static final String STATUS = "status";
    private static final String JOB_ID = "jobID";
    private final SecurityChecker securityChecker;
    private final UnSubscribeExit unSubscribeExit;
    private final SubscribeExit subscribeExit;
    private final String baseUiUrl;
    private final String urlSeparator;
    private final PollingParameters pollingParameter;

    public MtxTools(SecurityChecker securityChecker, UnSubscribeExit unSubscribeExit, SubscribeExit subscribeExit, String baseUiUrl, String urlSeparator, PollingParameters pollingParameter) {
        this.securityChecker = securityChecker;
        this.unSubscribeExit = unSubscribeExit;
        this.subscribeExit = subscribeExit;
        this.baseUiUrl = baseUiUrl;
        this.urlSeparator = urlSeparator;
        this.pollingParameter = pollingParameter;
    }

    public AsyncCallResult waitForCompletion(String jobId, StatusProvider statusProvider, PollingParameters pollingParameter) {
        Instant start = Instant.now();
        while (true) {
            try {
                Map<String, Object> result = statusProvider.getStatus(jobId);
                if (!result.containsKey(STATUS)) {
                    return new AsyncCallResult((Exception)new InternalError("Mtx sidecar returned no status"));
                }
                switch (MtxExecutionStatus.valueOf(((String)result.get(STATUS)).toUpperCase(Locale.ENGLISH))) {
                    case FINISHED: {
                        return AsyncCallResult.createOk();
                    }
                    case INITIAL: 
                    case QUEUED: 
                    case RUNNING: {
                        break;
                    }
                    case FAILED: {
                        return new AsyncCallResult((Exception)new InternalError("Provisioning service returned with status \"failed\""));
                    }
                    default: {
                        return new AsyncCallResult((Exception)new InternalError("Unexpected status" + (String)result.get(STATUS)));
                    }
                }
            }
            catch (Exception e) {
                return new AsyncCallResult(e);
            }
            if (Duration.between(start, Instant.now()).compareTo(pollingParameter.getRequestTimeout()) >= 0) {
                return new AsyncCallResult((Exception)new InternalError("Maximum waiting time on called service exceeded"));
            }
            Tools.waitSomeTime(pollingParameter.getInterval());
        }
    }

    public static String extractJobId(ServiceResponse<String> response) throws InternalException {
        Optional<String> location;
        String[] parts;
        String jobId = null;
        if (response.getHeaders() != null && (parts = (location = Arrays.stream(response.getHeaders()).filter(h -> h.getName().equalsIgnoreCase("Location")).map(NameValuePair::getValue).findFirst()).orElse("").split("/jobs/")).length == 2) {
            jobId = parts[1];
        }
        if (jobId == null) {
            jobId = (String)MtxTools.getResponseAsMap(response).get(JOB_ID);
        }
        if (StringUtils.isBlank(jobId)) {
            throw new InternalException("No job id returned");
        }
        return jobId;
    }

    private static Map<String, Object> getResponseAsMap(ServiceResponse<String> response) throws InternalException {
        if (response.getPayload().isPresent()) {
            try {
                return (Map)new Gson().fromJson((String)response.getPayload().get(), Map.class);
            }
            catch (JsonSyntaxException e) {
                throw new InternalException("No map returned from mtx service", (Throwable)e);
            }
        }
        return new HashMap<String, Object>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unsubscribe(String tenantId, SupplierWithInternalError<String> unsubscribeExecutor, StatusProvider statusProvider, DeletePayload deletePayload, boolean asynchronous, SaasRegistryCaller saasRegistryCaller) throws InternalError, ParameterError, AuthorityError {
        this.securityChecker.checkSubscriptionAuthority();
        Tools.checkExternalTenantId(tenantId);
        boolean isUnsubscribePossible = Boolean.TRUE.equals(asynchronous ? this.unSubscribeExit.onBeforeAsyncUnsubscribe(tenantId, deletePayload) : this.unSubscribeExit.onBeforeUnsubscribe(tenantId, deletePayload));
        if (isUnsubscribePossible) {
            String jobId = unsubscribeExecutor.get();
            if (asynchronous) {
                Executors.newSingleThreadExecutor().execute(() -> {
                    AsyncCallResult asyncCallResult = this.waitForCompletion(jobId, statusProvider, this.pollingParameter);
                    try {
                        Tools.waitSomeTime(SAAS_REGISTRY_WAIT_TIME);
                        saasRegistryCaller.callSaasRegistry(asyncCallResult.isOk(), asyncCallResult.isOk() ? "Operation succeeded" : "An error occurred", "");
                    }
                    catch (InternalError e) {
                        logger.error(e.getMessage());
                    }
                    finally {
                        if (asyncCallResult.isOk()) {
                            this.unSubscribeExit.onAfterAsyncUnsubscribe(tenantId, deletePayload);
                        } else {
                            logger.error("Provisioning service returned with an error", (Throwable)asyncCallResult.getException());
                        }
                    }
                });
                return;
            } else {
                AsyncCallResult asyncCallResult = this.waitForCompletion(jobId, statusProvider, this.pollingParameter);
                if (!asyncCallResult.isOk()) throw new InternalError(asyncCallResult.getException());
                this.unSubscribeExit.onAfterUnsubscribe(tenantId, deletePayload);
            }
            return;
        } else {
            logger.debug("Unsubscribe exit returned false=> No un-subscription performed");
        }
    }

    public String subscribe(String tenantId, SubscribeExecutor subscribeExecutor, StatusProvider statusProvider, SubscriptionPayload subscriptionPayload, boolean asynchronous, SaasRegistryCaller saasRegistryCaller) throws InternalError, ParameterError, AuthorityError {
        String jobId;
        this.securityChecker.checkSubscriptionAuthority();
        Tools.checkExternalTenantId(tenantId);
        InstanceCreationOptions instanceCreationOptions = asynchronous ? this.subscribeExit.onBeforeAsyncSubscribe(tenantId, subscriptionPayload) : this.subscribeExit.onBeforeSubscribe(tenantId, subscriptionPayload);
        String applicationUrl = Tools.getApplicationUrl(subscriptionPayload, this.subscribeExit, this.baseUiUrl, this.urlSeparator);
        try {
            jobId = subscribeExecutor.execute(instanceCreationOptions);
        }
        catch (InternalError e) {
            this.subscribeExit.onAfterSubscribe(tenantId, subscriptionPayload, false);
            throw e;
        }
        if (asynchronous) {
            Executors.newSingleThreadExecutor().execute(() -> {
                AsyncCallResult asyncCallResult = this.waitForCompletion(jobId, statusProvider, this.pollingParameter);
                if (asyncCallResult.isNotOk()) {
                    logger.error("Provisioning service returned with an error", (Throwable)asyncCallResult.getException());
                }
                try {
                    Tools.waitSomeTime(SAAS_REGISTRY_WAIT_TIME);
                    saasRegistryCaller.callSaasRegistry(asyncCallResult.isOk(), asyncCallResult.isOk() ? "Operation succeeded" : "An error occurred", applicationUrl);
                }
                catch (InternalError e) {
                    logger.error(e.getMessage());
                }
                finally {
                    this.subscribeExit.onAfterAsyncSubscribe(tenantId, subscriptionPayload, asyncCallResult.isOk());
                }
            });
        } else {
            AsyncCallResult asyncCallResult = this.waitForCompletion(jobId, statusProvider, this.pollingParameter);
            this.subscribeExit.onAfterSubscribe(tenantId, subscriptionPayload, asyncCallResult.isOk());
            if (asyncCallResult.isNotOk()) {
                throw new InternalError(asyncCallResult.getException());
            }
        }
        return applicationUrl;
    }

    @FunctionalInterface
    public static interface SubscribeExecutor {
        public String execute(InstanceCreationOptions var1) throws InternalError;
    }

    @FunctionalInterface
    public static interface SaasRegistryCaller {
        public void callSaasRegistry(boolean var1, String var2, String var3) throws InternalError;
    }

    @FunctionalInterface
    public static interface StatusProvider {
        public Map<String, Object> getStatus(String var1) throws InternalError, NotFound;
    }

    @FunctionalInterface
    public static interface SupplierWithInternalError<T> {
        public T get() throws InternalError;
    }
}

