/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.sap.cds.mtx.impl.Authenticator;
import com.sap.cloud.mt.subscription.MtxTools;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.cloud.mt.subscription.exceptions.NotFound;
import com.sap.cloud.mt.subscription.json.ApplicationForSidecar;
import com.sap.cloud.mt.subscription.json.DeletePayload;
import com.sap.cloud.mt.subscription.json.ManagedHanaForSidecar;
import com.sap.cloud.mt.subscription.json.SAPForSidecar;
import com.sap.cloud.mt.subscription.json.SidecarSubscriptionPayload;
import com.sap.cloud.mt.subscription.json.SidecarUnSubscriptionPayload;
import com.sap.cloud.mt.subscription.json.SubscriptionPayload;
import com.sap.cloud.mt.tools.api.CodeTools;
import com.sap.cloud.mt.tools.api.ResilienceConfig;
import com.sap.cloud.mt.tools.api.ServiceCall;
import com.sap.cloud.mt.tools.api.ServiceEndpoint;
import com.sap.cloud.mt.tools.api.ServiceResponse;
import com.sap.cloud.mt.tools.exception.InternalException;
import com.sap.cloud.mt.tools.exception.ServiceException;
import com.sap.xsa.core.instancemanager.client.InstanceCreationOptions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvisioningService {
    private static final Logger logger = LoggerFactory.getLogger(ProvisioningService.class);
    private static final String PROVISIONING_ENDPOINT = "/-/cds/saas-provisioning/tenant/";
    private static final String UPGRADE_ENDPOINT = "/-/cds/saas-provisioning/upgrade";
    private static final String UPGRADE_ALL_ENDPOINT = "/-/cds/saas-provisioning/upgradeAll";
    private static final String JOB_STATUS_ENDPOINT = "/-/cds/saas-provisioning/jobs/";
    private static final String MTX_PROVISIONING_SERVICE_DESTINATION = "com.sap.cds.mtxSidecar";
    private static final String UNEXPECTED_RETURN_CODE = "Unexpected return code ";
    private static final String PREFER = "prefer";
    private static final String RESPOND_ASYNC = "respond-async";
    private static final String JOB_ID = "jobID";
    private static final String TENANT = "tenant";
    private final Set<Integer> retryCodes = new HashSet<Integer>();
    private final ServiceEndpoint getStatusEndpoint;
    private final ServiceEndpoint subscribeEndpoint;
    private final ServiceEndpoint unsubscribeEndpoint;
    private final ServiceEndpoint upgradeEndpoint;
    private final ServiceEndpoint upgradeAllEndpoint;
    private final Authenticator authenticator;

    public ProvisioningService(String provisioningServiceUrl, ResilienceConfig resilienceConfig, Authenticator authenticator) throws InternalError {
        this.authenticator = authenticator;
        this.retryCodes.add(502);
        this.retryCodes.add(504);
        this.retryCodes.add(500);
        this.retryCodes.add(503);
        try {
            this.getStatusEndpoint = ServiceEndpoint.create().at(provisioningServiceUrl).destinationName(MTX_PROVISIONING_SERVICE_DESTINATION).path(JOB_STATUS_ENDPOINT).returnCodeChecker(c -> {
                if (c == 404) {
                    return new NotFound("Job id not known");
                }
                if (c != 200) {
                    return new InternalError(UNEXPECTED_RETURN_CODE + c);
                }
                return null;
            }).retry().forReturnCodes(this.retryCodes).config(resilienceConfig).end();
            this.subscribeEndpoint = ServiceEndpoint.create().at(provisioningServiceUrl).destinationName(MTX_PROVISIONING_SERVICE_DESTINATION).path(PROVISIONING_ENDPOINT).returnCodeChecker(c -> {
                if (CodeTools.code((Object)c).notIn((Object[])new Integer[]{202, 200})) {
                    return new InternalError(UNEXPECTED_RETURN_CODE + c);
                }
                return null;
            }).retry().forReturnCodes(this.retryCodes).config(resilienceConfig).end();
            this.unsubscribeEndpoint = ServiceEndpoint.create().at(provisioningServiceUrl).destinationName(MTX_PROVISIONING_SERVICE_DESTINATION).path(PROVISIONING_ENDPOINT).returnCodeChecker(c -> {
                if (CodeTools.code((Object)c).notIn((Object[])new Integer[]{202, 200, 204})) {
                    return new InternalError(UNEXPECTED_RETURN_CODE + c);
                }
                return null;
            }).retry().forReturnCodes(this.retryCodes).config(resilienceConfig).end();
            this.upgradeEndpoint = ServiceEndpoint.create().at(provisioningServiceUrl).destinationName(MTX_PROVISIONING_SERVICE_DESTINATION).path(UPGRADE_ENDPOINT).returnCodeChecker(c -> {
                if (CodeTools.code((Object)c).notIn((Object[])new Integer[]{202, 200, 204})) {
                    return new InternalError(UNEXPECTED_RETURN_CODE + c);
                }
                return null;
            }).retry().forReturnCodes(this.retryCodes).config(resilienceConfig).end();
            this.upgradeAllEndpoint = ServiceEndpoint.create().at(provisioningServiceUrl).destinationName(MTX_PROVISIONING_SERVICE_DESTINATION).path(UPGRADE_ALL_ENDPOINT).returnCodeChecker(c -> {
                if (CodeTools.code((Object)c).notIn((Object[])new Integer[]{202, 200, 204})) {
                    return new InternalError(UNEXPECTED_RETURN_CODE + c);
                }
                return null;
            }).retry().forReturnCodes(this.retryCodes).config(resilienceConfig).end();
        }
        catch (InternalException e) {
            throw new InternalError(e);
        }
    }

    public Map<String, Object> determineJobStatus(String jobId) throws InternalError, NotFound {
        ServiceCall getStatus = null;
        try {
            getStatus = this.getStatusEndpoint.createServiceCall().http().get().withoutPayload().pathParameter(jobId).noQuery().authenticationTokenSupplier(() -> this.authenticator.getAuthorization().orElse(null)).end();
            ServiceResponse response = getStatus.execute(Map.class);
            return response.getPayload().orElse(new HashMap());
        }
        catch (InternalException e) {
            throw new InternalError(e);
        }
        catch (ServiceException e) {
            if (e.getCause() instanceof InternalError) {
                throw (InternalError)e.getCause();
            }
            if (e.getCause() instanceof NotFound) {
                throw (NotFound)e.getCause();
            }
            throw new InternalError(e);
        }
    }

    public String subscribe(String tenantId, SubscriptionPayload subscriptionPayload, InstanceCreationOptions instanceCreationOptions) throws InternalError {
        SidecarSubscriptionPayload sidecarPayload = this.createSubscriptionPayloadForProvisioningService(subscriptionPayload, instanceCreationOptions);
        try {
            ServiceCall subscribe = this.subscribeEndpoint.createServiceCall().http().put().payload((Object)sidecarPayload).pathParameter(tenantId).noQuery().authenticationTokenSupplier(() -> this.authenticator.getAuthorization().orElse(null)).insertHeaderFields(ProvisioningService.getHeaderFieldsForAsyncCall(true)).end();
            ServiceResponse response = subscribe.execute(String.class);
            return MtxTools.extractJobId((ServiceResponse<String>)response);
        }
        catch (InternalException e) {
            throw new InternalError(e);
        }
        catch (ServiceException e) {
            if (e.getCause() instanceof InternalError) {
                throw (InternalError)e.getCause();
            }
            throw new InternalError(e);
        }
    }

    public String unsubscribe(String tenantId, DeletePayload deletePayloadCopy) throws InternalError {
        SidecarUnSubscriptionPayload sidecarPayload = new SidecarUnSubscriptionPayload(deletePayloadCopy);
        try {
            ServiceCall unsubscribe = this.unsubscribeEndpoint.createServiceCall().http().delete().payload((Object)sidecarPayload).pathParameter(tenantId).noQuery().authenticationTokenSupplier(() -> this.authenticator.getAuthorization().orElse(null)).insertHeaderFields(ProvisioningService.getHeaderFieldsForAsyncCall(true)).end();
            ServiceResponse response = unsubscribe.execute(String.class);
            return MtxTools.extractJobId((ServiceResponse<String>)response);
        }
        catch (InternalException e) {
            throw new InternalError(e);
        }
        catch (ServiceException e) {
            if (e.getCause() instanceof InternalError) {
                throw (InternalError)e.getCause();
            }
            throw new InternalError(e);
        }
    }

    public Map<String, Object> upgradeAll(Set<String> tenantIds, boolean asynchronously) throws InternalError {
        HashMap<String, Set<String>> upgradePayload = new HashMap<String, Set<String>>();
        if (tenantIds != null && !tenantIds.isEmpty()) {
            upgradePayload.put("tenants", tenantIds);
        }
        try {
            ServiceCall upgrade = this.upgradeAllEndpoint.createServiceCall().http().post().payload(upgradePayload).noPathParameter().noQuery().authenticationTokenSupplier(() -> this.authenticator.getAuthorization().orElse(null)).insertHeaderFields(ProvisioningService.getHeaderFieldsForAsyncCall(asynchronously)).end();
            ServiceResponse response = upgrade.execute(Map.class);
            return response.getPayload().orElse(new HashMap());
        }
        catch (InternalException e) {
            throw new InternalError(e);
        }
        catch (ServiceException e) {
            if (e.getCause() instanceof InternalError) {
                throw (InternalError)e.getCause();
            }
            throw new InternalError(e);
        }
    }

    private SidecarSubscriptionPayload createSubscriptionPayloadForProvisioningService(SubscriptionPayload subscriptionPayload, InstanceCreationOptions instanceCreationOptions) {
        SidecarSubscriptionPayload payload = new SidecarSubscriptionPayload(subscriptionPayload);
        if (StringUtils.isNotEmpty((CharSequence)subscriptionPayload.eventType)) {
            payload.eventType = subscriptionPayload.eventType;
        }
        boolean hasProvisioningParameters = false;
        boolean hasBindingParameters = false;
        if (instanceCreationOptions != null) {
            if (instanceCreationOptions.getProvisioningParameters() != null && instanceCreationOptions.getProvisioningParameters().size() > 0) {
                hasProvisioningParameters = true;
            }
            if (instanceCreationOptions.getBindingParameters() != null && instanceCreationOptions.getBindingParameters().size() > 0) {
                hasBindingParameters = true;
            }
        }
        if (hasProvisioningParameters || hasBindingParameters) {
            payload._application_ = new ApplicationForSidecar();
            payload._application_.sap = new SAPForSidecar();
            payload._application_.sap.managedHana = new ManagedHanaForSidecar();
            if (hasProvisioningParameters) {
                payload._application_.sap.managedHana.provisioning_parameters = instanceCreationOptions.getProvisioningParameters();
            }
            if (hasBindingParameters) {
                payload._application_.sap.managedHana.binding_parameters = instanceCreationOptions.getBindingParameters();
            }
        }
        return payload;
    }

    private static Map<String, String> getHeaderFieldsForAsyncCall(boolean asynchronous) {
        HashMap<String, String> headerFields = new HashMap<String, String>();
        if (asynchronous) {
            headerFields.put(PREFER, RESPOND_ASYNC);
        }
        return headerFields;
    }
}

