/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.sap.cds.mtx.impl.Authenticator;
import com.sap.cloud.mt.subscription.PollingParameters;
import com.sap.cloud.mt.tools.api.ResilienceConfig;

public class ProvisioningServiceSpecification {
    private final String url;
    private final ResilienceConfig resilienceConfig;
    private final Authenticator authenticator;
    private final PollingParameters polling;

    private ProvisioningServiceSpecification(String url, ResilienceConfig resilienceConfig, Authenticator authenticator, PollingParameters polling) {
        this.url = url;
        this.resilienceConfig = resilienceConfig;
        this.authenticator = authenticator;
        this.polling = polling;
    }

    public String getUrl() {
        return this.url;
    }

    public ResilienceConfig getResilienceConfig() {
        return this.resilienceConfig;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public PollingParameters getPolling() {
        return this.polling;
    }

    public static final class Builder {
        private String url;
        private ResilienceConfig resilienceConfig;
        private Authenticator authenticator;
        private PollingParameters polling;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder resilienceConfig(ResilienceConfig resilienceConfig) {
            this.resilienceConfig = resilienceConfig;
            return this;
        }

        public Builder authenticator(Authenticator authenticator) {
            this.authenticator = authenticator;
            return this;
        }

        public Builder polling(PollingParameters polling) {
            this.polling = polling;
            return this;
        }

        public ProvisioningServiceSpecification build() {
            return new ProvisioningServiceSpecification(this.url, this.resilienceConfig, this.authenticator, this.polling);
        }
    }
}

