/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.sap.cds.mtx.impl.Authenticator;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.cloud.mt.subscription.json.SaasCallbackPayload;
import com.sap.cloud.mt.tools.api.ResilienceConfig;
import com.sap.cloud.mt.tools.api.ServiceEndpoint;
import com.sap.cloud.mt.tools.exception.InternalException;
import com.sap.cloud.mt.tools.exception.ServiceException;
import java.util.HashMap;
import javax.naming.CommunicationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaasRegistry {
    private static final String APPLICATION_JSON = "application/json";
    public static final String SUCCEEDED = "SUCCEEDED";
    public static final String FAILED = "FAILED";
    private final Authenticator authenticator;
    private final String saasRegistryUrl;
    private static final String AUTHENTIFICATION_SCHEME = "Bearer";
    private static final Logger logger = LoggerFactory.getLogger(SaasRegistry.class);
    private static final String SAAS_REGISTRY_DESTINATION = "com.sap.cds.saasRegistry";
    private final ResilienceConfig resilienceConfig;

    public SaasRegistry(Authenticator authenticator, String saasRegistryUrl, ResilienceConfig resilienceConfig) {
        this.authenticator = authenticator;
        this.saasRegistryUrl = saasRegistryUrl;
        this.resilienceConfig = resilienceConfig;
    }

    public SaasRegistry(Authenticator authenticator, String saasRegistryUrl) {
        this(authenticator, saasRegistryUrl, ResilienceConfig.NONE);
    }

    public void callBackSaasRegistry(boolean success, String message, String subscriptionUrl, String callbackUrl) throws InternalError {
        ServiceEndpoint saasRegistry = null;
        try {
            saasRegistry = ServiceEndpoint.create().at(this.saasRegistryUrl).destinationName(SAAS_REGISTRY_DESTINATION).path(callbackUrl).returnCodeChecker(c -> {
                if (c != 200) {
                    return new InternalError("Saas registry returned http status " + c + " . Called saas registry url is " + this.saasRegistryUrl + callbackUrl);
                }
                return null;
            }).retry().forReturnCodes(new Integer[]{502, 504, 500, 503}).config(this.resilienceConfig).retryAuthenticationTokenDetermination().forExceptions(new Class[]{CommunicationException.class}).config(this.resilienceConfig).end();
        }
        catch (InternalException e) {
            throw new InternalError(e);
        }
        SaasCallbackPayload payload = this.getSaasCallbackPayload(success, message, subscriptionUrl);
        HashMap<String, String> headerFields = new HashMap<String, String>();
        headerFields.put("Accept", APPLICATION_JSON);
        logger.debug("Call saas registry at url {}", (Object)(this.saasRegistryUrl + callbackUrl));
        try {
            saasRegistry.createServiceCall().http().put().payload((Object)payload).noPathParameter().noQuery().authenticationTokenSupplier(() -> this.authenticator.getAuthorization().orElse(null)).insertHeaderFields(headerFields).end().execute();
        }
        catch (InternalException e) {
            throw new InternalError(e.getCause());
        }
        catch (ServiceException e) {
            if (e.getCause() instanceof InternalError) {
                throw (InternalError)e.getCause();
            }
            throw new InternalError(e.getCause());
        }
    }

    private SaasCallbackPayload getSaasCallbackPayload(boolean success, String message, String subscriptionUrl) {
        SaasCallbackPayload payload = new SaasCallbackPayload();
        payload.message = message;
        payload.status = success ? SUCCEEDED : FAILED;
        payload.subscriptionUrl = subscriptionUrl;
        return payload;
    }
}

