/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.cloud.mt.subscription.exceptions.NotFound;
import com.sap.cloud.mt.subscription.json.ApplicationForSidecar;
import com.sap.cloud.mt.subscription.json.DeletePayload;
import com.sap.cloud.mt.subscription.json.ManagedHanaForSidecar;
import com.sap.cloud.mt.subscription.json.SAPForSidecar;
import com.sap.cloud.mt.subscription.json.SidecarSubscriptionPayload;
import com.sap.cloud.mt.subscription.json.SidecarUnSubscriptionPayload;
import com.sap.cloud.mt.subscription.json.SidecarUpgradePayload;
import com.sap.cloud.mt.subscription.json.SubscriptionPayload;
import com.sap.cloud.mt.tools.api.ResilienceConfig;
import com.sap.cloud.mt.tools.api.ServiceCall;
import com.sap.cloud.mt.tools.api.ServiceEndpoint;
import com.sap.cloud.mt.tools.api.ServiceResponse;
import com.sap.cloud.mt.tools.exception.InternalException;
import com.sap.cloud.mt.tools.exception.ServiceException;
import com.sap.xsa.core.instancemanager.client.InstanceCreationOptions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class SidecarAccess {
    private static final String SIDECAR_PROVISIONING_ENDPOINT = "/mtx/v1/provisioning/tenant/";
    private static final String SIDECAR_UPGRADE_ENDPOINT = "/mtx/v1/model/asyncUpgrade";
    private static final String SIDECAR_STATUS_ENDPOINT = "/mtx/v1/model/status/";
    private static final String STATUS_CALLBACK = "STATUS_CALLBACK";
    private static final String MT_LIB_CALLBACK_URL = "MTX_STATUS_CALLBACK";
    private static final String MTX_SIDECAR_DESTINATION = "com.sap.cds.mtxSidecar";
    private static final String UNEXPECTED_RETURN_CODE = "Unexpected return code ";
    private final Set<Integer> retryCodes = new HashSet<Integer>();
    private final ServiceEndpoint upgradeEndpoint;
    private final ServiceEndpoint getStatusEndpoint;
    private final ServiceEndpoint subscribeEndpoint;
    private final ServiceEndpoint unsubscribeEndpoint;

    SidecarAccess(String sidecarUrl, ResilienceConfig resilienceConfig) throws InternalError {
        this.retryCodes.add(502);
        this.retryCodes.add(504);
        this.retryCodes.add(500);
        this.retryCodes.add(503);
        try {
            this.upgradeEndpoint = ServiceEndpoint.create().at(sidecarUrl).destinationName(MTX_SIDECAR_DESTINATION).path(SIDECAR_UPGRADE_ENDPOINT).returnCodeChecker(c -> {
                if (c != 200) {
                    return new InternalError(UNEXPECTED_RETURN_CODE + c);
                }
                return null;
            }).retry().forReturnCodes(this.retryCodes).config(resilienceConfig).end();
            this.getStatusEndpoint = ServiceEndpoint.create().at(sidecarUrl).destinationName(MTX_SIDECAR_DESTINATION).path(SIDECAR_STATUS_ENDPOINT).returnCodeChecker(c -> {
                if (c == 404) {
                    return new NotFound("Job id not known");
                }
                if (c != 200) {
                    return new InternalError(UNEXPECTED_RETURN_CODE + c);
                }
                return null;
            }).retry().forReturnCodes(this.retryCodes).config(resilienceConfig).end();
            this.subscribeEndpoint = ServiceEndpoint.create().at(sidecarUrl).destinationName(MTX_SIDECAR_DESTINATION).path(SIDECAR_PROVISIONING_ENDPOINT).returnCodeChecker(c -> {
                if (c != 201 && c != 200 && c != 202) {
                    return new InternalError(UNEXPECTED_RETURN_CODE + c);
                }
                return null;
            }).retry().forReturnCodes(this.retryCodes).config(resilienceConfig).end();
            this.unsubscribeEndpoint = ServiceEndpoint.create().at(sidecarUrl).destinationName(MTX_SIDECAR_DESTINATION).path(SIDECAR_PROVISIONING_ENDPOINT).returnCodeChecker(c -> {
                if (c != 202 && c != 204) {
                    return new InternalError(UNEXPECTED_RETURN_CODE + c);
                }
                return null;
            }).retry().forReturnCodes(this.retryCodes).config(resilienceConfig).end();
        }
        catch (InternalException e) {
            throw new InternalError(e);
        }
    }

    public String callSidecarUpgrade(String jwt, SidecarUpgradePayload upgradePayload) throws InternalError {
        ServiceCall upgrade = null;
        try {
            upgrade = this.upgradeEndpoint.createServiceCall().http().post().payload((Object)upgradePayload).noPathParameter().noQuery().authenticationToken(jwt).end();
            ServiceResponse response = upgrade.execute(String.class);
            return response.getPayload().isPresent() ? (String)response.getPayload().get() : "";
        }
        catch (InternalException e) {
            throw new InternalError(e);
        }
        catch (ServiceException e) {
            if (e.getCause() instanceof InternalError) {
                throw (InternalError)e.getCause();
            }
            throw new InternalError(e);
        }
    }

    public String callSidecarStatus(String jobId, String jwt) throws InternalError, NotFound {
        ServiceCall getStatus = null;
        try {
            getStatus = this.getStatusEndpoint.createServiceCall().http().get().withoutPayload().pathParameter(jobId).noQuery().authenticationToken(jwt).end();
            ServiceResponse response = getStatus.execute(String.class);
            if (response.getHttpStatusCode() == 404) {
                throw new NotFound("Job id not known");
            }
            return response.getPayload().isPresent() ? (String)response.getPayload().get() : "";
        }
        catch (InternalException e) {
            throw new InternalError(e);
        }
        catch (ServiceException e) {
            if (e.getCause() instanceof InternalError) {
                throw (InternalError)e.getCause();
            }
            if (e.getCause() instanceof NotFound) {
                throw (NotFound)e.getCause();
            }
            throw new InternalError(e);
        }
    }

    public void callSidecarSubscribe(String tenantId, String jwt, SubscriptionPayload subscriptionPayload, InstanceCreationOptions instanceCreationOptions, String applicationUrl, boolean asyncCall, String saasRegistryUrl, String asyncSubscribeCallBackUrl) throws InternalError {
        SidecarSubscriptionPayload sidecarPayload = this.getSubscriptionPayloadForSidecar(subscriptionPayload, instanceCreationOptions);
        sidecarPayload._applicationUrlFromJava_ = applicationUrl;
        HashMap<String, String> headerFields = new HashMap<String, String>();
        if (asyncCall) {
            headerFields.put(MT_LIB_CALLBACK_URL, asyncSubscribeCallBackUrl);
            headerFields.put(STATUS_CALLBACK, saasRegistryUrl);
        }
        ServiceCall subscribe = null;
        try {
            subscribe = this.subscribeEndpoint.createServiceCall().http().put().payload((Object)sidecarPayload).pathParameter(tenantId).noQuery().authenticationToken(jwt).insertHeaderFields(headerFields).end();
            subscribe.execute();
        }
        catch (InternalException e) {
            throw new InternalError(e);
        }
        catch (ServiceException e) {
            if (e.getCause() instanceof InternalError) {
                throw (InternalError)e.getCause();
            }
            throw new InternalError(e);
        }
    }

    public void callSidecarUnsubscribe(String tenantId, String jwt, DeletePayload deletePayloadCopy, boolean asyncCall, String saasRegistryUrl, String asyncUnsubscribeCallBackUrl) throws InternalError {
        SidecarUnSubscriptionPayload sidecarPayload = new SidecarUnSubscriptionPayload(deletePayloadCopy);
        try {
            if (asyncCall) {
                HashMap<String, String> headerFields = new HashMap<String, String>();
                headerFields.put(MT_LIB_CALLBACK_URL, asyncUnsubscribeCallBackUrl);
                headerFields.put(STATUS_CALLBACK, saasRegistryUrl);
                ServiceCall unsubscribe = this.unsubscribeEndpoint.createServiceCall().http().delete().payload((Object)sidecarPayload).pathParameter(tenantId).noQuery().authenticationToken(jwt).insertHeaderFields(headerFields).end();
                unsubscribe.execute();
            } else {
                ServiceCall unsubscribe = this.unsubscribeEndpoint.createServiceCall().http().delete().withoutPayload().pathParameter(tenantId).noQuery().authenticationToken(jwt).end();
                unsubscribe.execute();
            }
        }
        catch (InternalException e) {
            throw new InternalError(e);
        }
        catch (ServiceException e) {
            if (e.getCause() instanceof InternalError) {
                throw (InternalError)e.getCause();
            }
            throw new InternalError(e);
        }
    }

    private SidecarSubscriptionPayload getSubscriptionPayloadForSidecar(SubscriptionPayload subscriptionPayload, InstanceCreationOptions instanceCreationOptions) {
        SidecarSubscriptionPayload payload = new SidecarSubscriptionPayload(subscriptionPayload);
        boolean hasProvisioningParameters = false;
        boolean hasBindingParameters = false;
        if (instanceCreationOptions != null) {
            if (instanceCreationOptions.getProvisioningParameters() != null && instanceCreationOptions.getProvisioningParameters().size() > 0) {
                hasProvisioningParameters = true;
            }
            if (instanceCreationOptions.getBindingParameters() != null && instanceCreationOptions.getBindingParameters().size() > 0) {
                hasBindingParameters = true;
            }
        }
        if (hasProvisioningParameters || hasBindingParameters) {
            payload._application_ = new ApplicationForSidecar();
            payload._application_.sap = new SAPForSidecar();
            payload._application_.sap.managedHana = new ManagedHanaForSidecar();
            if (hasProvisioningParameters) {
                payload._application_.sap.managedHana.provisioning_parameters = instanceCreationOptions.getProvisioningParameters();
            }
            if (hasBindingParameters) {
                payload._application_.sap.managedHana.binding_parameters = instanceCreationOptions.getBindingParameters();
            }
        }
        return payload;
    }
}

