/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.sap.cloud.mt.subscription.MtxTools;
import com.sap.cloud.mt.subscription.SaasRegistry;
import com.sap.cloud.mt.subscription.SecurityChecker;
import com.sap.cloud.mt.subscription.SidecarAccess;
import com.sap.cloud.mt.subscription.Subscriber;
import com.sap.cloud.mt.subscription.Tools;
import com.sap.cloud.mt.subscription.exceptions.AuthorityError;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.cloud.mt.subscription.exceptions.NotFound;
import com.sap.cloud.mt.subscription.exceptions.NotSupported;
import com.sap.cloud.mt.subscription.exceptions.ParameterError;
import com.sap.cloud.mt.subscription.exits.Exits;
import com.sap.cloud.mt.subscription.json.ApplicationDependency;
import com.sap.cloud.mt.subscription.json.Cloner;
import com.sap.cloud.mt.subscription.json.DeletePayload;
import com.sap.cloud.mt.subscription.json.SidecarSubscribeCallBackPayload;
import com.sap.cloud.mt.subscription.json.SidecarUnSubscribeCallBackPayload;
import com.sap.cloud.mt.subscription.json.SidecarUpgradePayload;
import com.sap.cloud.mt.subscription.json.SubscriptionPayload;
import com.sap.cloud.mt.tools.api.ResilienceConfig;
import com.sap.xsa.core.instancemanager.client.InstanceCreationOptions;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriberSidecarImpl
implements Subscriber {
    private static final Logger logger = LoggerFactory.getLogger(SubscriberSidecarImpl.class);
    private final Exits exits;
    private final String baseUiUrl;
    private final String urlSeparator;
    private final SecurityChecker securityChecker;
    private final SaasRegistry saasRegistry;
    private final SidecarAccess sidecarAccess;

    private SubscriberSidecarImpl(String baseUiUrl, String urlSeparator, Exits exits, SecurityChecker securityChecker, SaasRegistry saasRegistry, SidecarAccess sidecarAccess) throws InternalError {
        this.exits = exits;
        this.baseUiUrl = baseUiUrl;
        this.urlSeparator = urlSeparator;
        this.saasRegistry = saasRegistry;
        if (exits.getUnSubscribeExit() == null) {
            throw new InternalError("No unsubscribe exit found");
        }
        this.securityChecker = securityChecker;
        this.sidecarAccess = sidecarAccess;
    }

    @Override
    public void unsubscribe(String tenantId, DeletePayload deletePayload, String jwt) throws InternalError, ParameterError, AuthorityError {
        this.unsubscribe(tenantId, deletePayload, jwt, null, null);
    }

    @Override
    public void unsubscribe(String tenantId, DeletePayload deletePayload, String jwt, String saasRegistryUrl, String asyncUnsubscribeCallBackUrl) throws InternalError, ParameterError, AuthorityError {
        boolean asyncCall = this.isAsyncCall(saasRegistryUrl);
        this.securityChecker.checkSubscriptionAuthority();
        Tools.checkExternalTenantId(tenantId);
        boolean processUnsubscribe = false;
        processUnsubscribe = asyncCall ? this.exits.getUnSubscribeExit().onBeforeAsyncUnsubscribe(tenantId, Cloner.clone(deletePayload)).booleanValue() : this.exits.getUnSubscribeExit().onBeforeUnsubscribe(tenantId, Cloner.clone(deletePayload)).booleanValue();
        if (processUnsubscribe) {
            if (asyncCall) {
                try {
                    this.unsubscribeViaSidecar(tenantId, jwt, deletePayload, true, saasRegistryUrl, asyncUnsubscribeCallBackUrl);
                }
                catch (InternalError e) {
                    Tools.waitSomeTime(MtxTools.SAAS_REGISTRY_WAIT_TIME);
                    this.saasRegistry.callBackSaasRegistry(false, e.getMessage(), null, saasRegistryUrl);
                    throw e;
                }
            } else {
                this.unsubscribeViaSidecar(tenantId, jwt, deletePayload, false, null, asyncUnsubscribeCallBackUrl);
                this.exits.getUnSubscribeExit().onAfterUnsubscribe(tenantId, Cloner.clone(deletePayload));
            }
        } else {
            logger.debug("Unsubscribe exit returned false=> No un-subscription performed");
        }
    }

    private boolean isAsyncCall(String saasRegistryUrl) {
        return saasRegistryUrl != null && !saasRegistryUrl.isEmpty();
    }

    @Override
    public void unsubscribeCallback(SidecarUnSubscribeCallBackPayload sidecarPayload, String jwt) throws AuthorityError, InternalError {
        this.securityChecker.checkSubscriptionAuthority();
        boolean success = sidecarPayload.status.equals("SUCCEEDED");
        if (success) {
            this.exits.getUnSubscribeExit().onAfterAsyncUnsubscribe(sidecarPayload.tenantId, Cloner.clone(sidecarPayload.saasRequestPayload));
        } else {
            logger.error(sidecarPayload.message);
        }
        try {
            this.saasRegistry.callBackSaasRegistry(success, sidecarPayload.message, null, sidecarPayload.saasCallbackUrl);
        }
        catch (InternalError e) {
            logger.error(e.getMessage());
            try {
                this.saasRegistry.callBackSaasRegistry(false, e.getMessage(), null, sidecarPayload.saasCallbackUrl);
            }
            catch (InternalError internalError) {
                logger.error(internalError.getMessage());
            }
        }
    }

    @Override
    public List<ApplicationDependency> getApplicationDependencies(String jwt) throws AuthorityError {
        this.securityChecker.checkSubscriptionAuthority();
        return this.exits.getDependencyExit() != null ? this.exits.getDependencyExit().onGetDependencies() : new ArrayList();
    }

    @Override
    public String subscribe(String tenantId, SubscriptionPayload subscriptionPayload, String jwt) throws InternalError, ParameterError, AuthorityError {
        return this.subscribe(tenantId, subscriptionPayload, jwt, null, null);
    }

    @Override
    public String subscribe(String tenantId, SubscriptionPayload subscriptionPayload, String jwt, String saasRegistryUrl, String asyncSubscribeCallBackUrl) throws InternalError, ParameterError, AuthorityError {
        boolean asyncCall = this.isAsyncCall(saasRegistryUrl);
        this.securityChecker.checkSubscriptionAuthority();
        Tools.checkExternalTenantId(tenantId);
        InstanceCreationOptions instanceCreationOptions = null;
        instanceCreationOptions = asyncCall ? this.exits.getSubscribeExit().onBeforeAsyncSubscribe(tenantId, Cloner.clone(subscriptionPayload)) : this.exits.getSubscribeExit().onBeforeSubscribe(tenantId, Cloner.clone(subscriptionPayload));
        String applicationUrl = Tools.getApplicationUrl(subscriptionPayload, this.exits.getSubscribeExit(), this.baseUiUrl, this.urlSeparator);
        if (asyncCall) {
            try {
                this.subscribeViaSidecar(tenantId, jwt, subscriptionPayload, instanceCreationOptions, applicationUrl, true, saasRegistryUrl, asyncSubscribeCallBackUrl);
            }
            catch (InternalError e) {
                this.exits.getSubscribeExit().onAfterAsyncSubscribe(tenantId, Cloner.clone(subscriptionPayload), false);
                Tools.waitSomeTime(MtxTools.SAAS_REGISTRY_WAIT_TIME);
                this.saasRegistry.callBackSaasRegistry(false, e.getMessage(), null, saasRegistryUrl);
                throw e;
            }
        }
        try {
            this.subscribeViaSidecar(tenantId, jwt, subscriptionPayload, instanceCreationOptions, applicationUrl, false, null, asyncSubscribeCallBackUrl);
            this.exits.getSubscribeExit().onAfterSubscribe(tenantId, Cloner.clone(subscriptionPayload), true);
        }
        catch (InternalError internalError) {
            this.exits.getSubscribeExit().onAfterSubscribe(tenantId, Cloner.clone(subscriptionPayload), false);
            throw internalError;
        }
        return applicationUrl;
    }

    @Override
    public void subscribeCallback(String jwt, SidecarSubscribeCallBackPayload sidecarPayload) throws AuthorityError, InternalError {
        this.securityChecker.checkSubscriptionAuthority();
        boolean success = sidecarPayload.status.equals("SUCCEEDED");
        this.exits.getSubscribeExit().onAfterAsyncSubscribe(sidecarPayload.tenantId, Cloner.clone(sidecarPayload.saasRequestPayload), success);
        if (!success) {
            logger.error(sidecarPayload.message);
        }
        this.saasRegistry.callBackSaasRegistry(success, sidecarPayload.message, sidecarPayload.saasRequestPayload._applicationUrlFromJava_, sidecarPayload.saasCallbackUrl);
    }

    @Override
    public void setupDbTables(List<String> tenants, String jwt) throws InternalError, NotSupported, AuthorityError {
        this.securityChecker.checkInitDbAuthority();
        logger.debug("Synchronous init db is not supported with sidecar");
        throw new NotSupported("Synchronous init db is not supported with sidecar");
    }

    @Override
    public String setupDbTablesAsync(List<String> tenants, String jwt) throws InternalError, AuthorityError {
        this.securityChecker.checkInitDbAuthority();
        SidecarUpgradePayload upgradePayload = new SidecarUpgradePayload();
        upgradePayload.tenants = tenants.toArray(new String[tenants.size()]);
        return this.sidecarAccess.callSidecarUpgrade(jwt, upgradePayload);
    }

    @Override
    public String updateStatus(String jobId, String jwt) throws InternalError, ParameterError, NotFound, AuthorityError {
        this.securityChecker.checkInitDbAuthority();
        if (!jobId.matches("^[_a-zA-Z0-9\\-]+$")) {
            throw new ParameterError("Job id contains illegal characters");
        }
        return this.sidecarAccess.callSidecarStatus(jobId, jwt);
    }

    @Override
    public void callSaasRegistry(boolean ok, String message, String applicationUrl, String saasRegistryUrl) throws InternalError {
        this.saasRegistry.callBackSaasRegistry(ok, message, applicationUrl, saasRegistryUrl);
    }

    private void subscribeViaSidecar(String tenantId, String jwt, SubscriptionPayload subscriptionPayload, InstanceCreationOptions instanceCreationOptions, String applicationUrl, boolean asyncCall, String saasRegistryUrl, String asyncSubscribeCallBackUrl) throws InternalError {
        try {
            this.sidecarAccess.callSidecarSubscribe(tenantId, jwt, subscriptionPayload, instanceCreationOptions, applicationUrl, asyncCall, saasRegistryUrl, asyncSubscribeCallBackUrl);
        }
        catch (Exception e) {
            this.exits.getSubscribeExit().onAfterSubscribe(tenantId, Cloner.clone(subscriptionPayload), false);
            throw new InternalError(e);
        }
    }

    private void unsubscribeViaSidecar(String tenantId, String jwt, DeletePayload deletePayloadCopy, boolean asyncCall, String saasRegistryUrl, String asyncUnsubscribeCallBackUrl) throws InternalError {
        try {
            this.sidecarAccess.callSidecarUnsubscribe(tenantId, jwt, deletePayloadCopy, asyncCall, saasRegistryUrl, asyncUnsubscribeCallBackUrl);
        }
        catch (Exception e) {
            throw new InternalError(e);
        }
    }

    public static final class SubscriberSidecarImplBuilder {
        private Exits exits;
        private String baseUiUrl;
        private String urlSeparator;
        private SecurityChecker securityChecker;
        private SaasRegistry saasRegistry;
        private SidecarAccess sidecarAccess;
        private String sidecarUrl;
        private ResilienceConfig resilienceConfig = ResilienceConfig.NONE;

        private SubscriberSidecarImplBuilder() {
        }

        public static SubscriberSidecarImplBuilder create() {
            return new SubscriberSidecarImplBuilder();
        }

        public SubscriberSidecarImplBuilder exits(Exits exits) {
            this.exits = exits;
            return this;
        }

        public SubscriberSidecarImplBuilder baseUiUrl(String baseUiUrl) {
            this.baseUiUrl = baseUiUrl;
            return this;
        }

        public SubscriberSidecarImplBuilder urlSeparator(String urlSeparator) {
            this.urlSeparator = urlSeparator;
            return this;
        }

        public SubscriberSidecarImplBuilder securityChecker(SecurityChecker securityChecker) {
            this.securityChecker = securityChecker;
            return this;
        }

        public SubscriberSidecarImplBuilder saasRegistry(SaasRegistry saasRegistry) {
            this.saasRegistry = saasRegistry;
            return this;
        }

        public SubscriberSidecarImplBuilder resilienceConfig(ResilienceConfig resilienceConfig) {
            if (resilienceConfig != null) {
                this.resilienceConfig = resilienceConfig;
            }
            return this;
        }

        public SubscriberSidecarImplBuilder sidecarAccess(SidecarAccess sidecarAccess) {
            this.sidecarAccess = sidecarAccess;
            return this;
        }

        public SubscriberSidecarImplBuilder sidecarUrl(String sidecarUrl) {
            this.sidecarUrl = sidecarUrl;
            return this;
        }

        public SubscriberSidecarImpl build() throws InternalError {
            if (this.sidecarAccess == null) {
                this.sidecarAccess = new SidecarAccess(this.sidecarUrl, this.resilienceConfig);
            }
            return new SubscriberSidecarImpl(this.baseUiUrl, this.urlSeparator, this.exits, this.securityChecker, this.saasRegistry, this.sidecarAccess);
        }
    }
}

