/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cloud.mt.subscription.InstanceLifecycleManager;
import com.sap.cloud.mt.subscription.MtxTools;
import com.sap.cloud.mt.subscription.PollingParameters;
import com.sap.cloud.mt.subscription.ProvisioningService;
import com.sap.cloud.mt.subscription.ProvisioningServiceSpecification;
import com.sap.cloud.mt.subscription.SaasRegistry;
import com.sap.cloud.mt.subscription.SecurityChecker;
import com.sap.cloud.mt.subscription.Subscriber;
import com.sap.cloud.mt.subscription.Tools;
import com.sap.cloud.mt.subscription.exceptions.AuthorityError;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.cloud.mt.subscription.exceptions.NotFound;
import com.sap.cloud.mt.subscription.exceptions.ParameterError;
import com.sap.cloud.mt.subscription.exits.Exits;
import com.sap.cloud.mt.subscription.json.ApplicationDependency;
import com.sap.cloud.mt.subscription.json.DeletePayload;
import com.sap.cloud.mt.subscription.json.SidecarSubscribeCallBackPayload;
import com.sap.cloud.mt.subscription.json.SidecarUnSubscribeCallBackPayload;
import com.sap.cloud.mt.subscription.json.SubscriptionPayload;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class SubscriberStreamlinedMtx
implements Subscriber {
    public static final String ALL_TENANTS = "all";
    private final Exits exits;
    private final SecurityChecker securityChecker;
    private final SaasRegistry saasRegistry;
    private final ProvisioningService provisioningService;
    private final InstanceLifecycleManager instanceLifecycleManager;
    private final MtxTools mtxTools;

    private SubscriberStreamlinedMtx(Exits exits, String baseUiUrl, String urlSeparator, SecurityChecker securityChecker, SaasRegistry saasRegistry, ProvisioningService provisioningService, PollingParameters provisioningServicePolling, InstanceLifecycleManager instanceLifecycleManager) throws InternalError {
        this.exits = exits;
        this.saasRegistry = saasRegistry;
        this.instanceLifecycleManager = instanceLifecycleManager;
        if (exits.getUnSubscribeExit() == null) {
            throw new InternalError("No unsubscribe exit found");
        }
        this.securityChecker = securityChecker;
        this.mtxTools = new MtxTools(securityChecker, exits.getUnSubscribeExit(), exits.getSubscribeExit(), baseUiUrl, urlSeparator, provisioningServicePolling);
        this.provisioningService = provisioningService;
    }

    @Override
    public String subscribe(String tenantId, SubscriptionPayload subscriptionPayload, String jwt) throws InternalError, ParameterError, AuthorityError {
        return this.subscribeSynchronously(tenantId, subscriptionPayload);
    }

    @Override
    public String subscribe(String tenantId, SubscriptionPayload subscriptionPayload, String jwt, String saasRegistryUrl, String javaCallBackUrl) throws InternalError, ParameterError, AuthorityError {
        return this.subscribeAndCallSaasRegistry(tenantId, subscriptionPayload, jwt, saasRegistryUrl);
    }

    public String subscribeAndCallSaasRegistry(String tenantId, SubscriptionPayload subscriptionPayload, String jwt, String saasRegistryUrl) throws InternalError, ParameterError, AuthorityError {
        this.checkSaasRegistryUrl(saasRegistryUrl);
        return this.subscribeAsynchronously(tenantId, subscriptionPayload, saasRegistryUrl);
    }

    @Override
    public void unsubscribe(String tenantId, DeletePayload deletePayload, String jwt) throws InternalError, ParameterError, AuthorityError {
        this.unsubscribeSynchronously(tenantId, deletePayload);
    }

    @Override
    public void unsubscribe(String tenantId, DeletePayload deletePayload, String jwt, String saasRegistryUrl, String javaCallBackUrl) throws InternalError, ParameterError, AuthorityError {
        this.unsubscribeAndCallSaasRegistry(tenantId, deletePayload, jwt, saasRegistryUrl);
    }

    public void unsubscribeAndCallSaasRegistry(String tenantId, DeletePayload deletePayload, String jwt, String saasRegistryUrl) throws InternalError, ParameterError, AuthorityError {
        this.checkSaasRegistryUrl(saasRegistryUrl);
        this.unsubscribeAsynchronously(tenantId, deletePayload, saasRegistryUrl);
    }

    @Override
    public List<ApplicationDependency> getApplicationDependencies(String jwt) throws AuthorityError {
        this.securityChecker.checkSubscriptionAuthority();
        return this.exits.getDependencyExit() != null ? this.exits.getDependencyExit().onGetDependencies() : new ArrayList();
    }

    @Override
    public void setupDbTables(List<String> tenants, String jwt) throws InternalError, AuthorityError, ParameterError {
        this.setupDbTables(tenants, false);
    }

    @Override
    public String setupDbTablesAsync(List<String> tenants, String jwt) throws InternalError, AuthorityError, ParameterError {
        try {
            return new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(this.setupDbTables(tenants, true));
        }
        catch (JsonProcessingException e) {
            throw new InternalError(e);
        }
    }

    @Override
    public String updateStatus(String jobId, String jwt) throws InternalError, ParameterError, NotFound, AuthorityError {
        this.securityChecker.checkInitDbAuthority();
        if (!jobId.matches("^[_a-zA-Z0-9\\-]+$")) {
            throw new ParameterError("Job id contains illegal characters");
        }
        try {
            return new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(this.provisioningService.determineJobStatus(jobId));
        }
        catch (JsonProcessingException e) {
            throw new InternalError(e);
        }
    }

    @Override
    public void callSaasRegistry(boolean ok, String message, String applicationUrl, String saasRegistryUrl) throws InternalError {
        this.saasRegistry.callBackSaasRegistry(ok, message, applicationUrl, saasRegistryUrl);
    }

    @Override
    public void unsubscribeCallback(SidecarUnSubscribeCallBackPayload sidecarCallBackPayload, String jwt) throws InternalError, AuthorityError {
        throw new InternalError("Provisioning service works without callback");
    }

    @Override
    public void subscribeCallback(String jwt, SidecarSubscribeCallBackPayload sidecarCallBackPayload) throws InternalError, AuthorityError {
        throw new InternalError("Provisioning service works without callback");
    }

    private void unsubscribeSynchronously(String tenantId, DeletePayload deletePayload) throws InternalError, ParameterError, AuthorityError {
        this.mtxTools.unsubscribe(tenantId, () -> this.provisioningService.unsubscribe(tenantId, deletePayload), this.provisioningService::determineJobStatus, deletePayload, false, null);
    }

    private void unsubscribeAsynchronously(String tenantId, DeletePayload deletePayload, String saasRegistryUrl) throws InternalError, ParameterError, AuthorityError {
        if (this.saasRegistry == null) {
            throw new InternalError("No saas registry provided");
        }
        this.mtxTools.unsubscribe(tenantId, () -> this.provisioningService.unsubscribe(tenantId, deletePayload), this.provisioningService::determineJobStatus, deletePayload, true, (isOk, message, applicationUrl) -> this.saasRegistry.callBackSaasRegistry(isOk, message, applicationUrl, saasRegistryUrl));
    }

    private String subscribeSynchronously(String tenantId, SubscriptionPayload subscriptionPayload) throws InternalError, ParameterError, AuthorityError {
        return this.mtxTools.subscribe(tenantId, instanceCreationOptions -> this.provisioningService.subscribe(tenantId, subscriptionPayload, instanceCreationOptions), this.provisioningService::determineJobStatus, subscriptionPayload, false, null);
    }

    private String subscribeAsynchronously(String tenantId, SubscriptionPayload subscriptionPayload, String saasRegistryUrl) throws InternalError, ParameterError, AuthorityError {
        if (this.saasRegistry == null) {
            throw new InternalError("No saas registry provided");
        }
        return this.mtxTools.subscribe(tenantId, instanceCreationOptions -> this.provisioningService.subscribe(tenantId, subscriptionPayload, instanceCreationOptions), this.provisioningService::determineJobStatus, subscriptionPayload, true, (isOk, message, applicationUrl) -> this.saasRegistry.callBackSaasRegistry(isOk, message, applicationUrl, saasRegistryUrl));
    }

    private Map<String, Object> setupDbTables(List<String> tenants, boolean asynchronously) throws InternalError, AuthorityError, ParameterError {
        this.securityChecker.checkInitDbAuthority();
        Tools.checkExternalTenantIds(tenants);
        if (tenants.isEmpty()) {
            throw new ParameterError("No tenant specified");
        }
        if (this.exits.getInitDbExit() != null) {
            this.exits.getInitDbExit().onBeforeInitDb(tenants);
        }
        Set<String> tenantSet = new HashSet<String>(tenants);
        try {
            if (tenantSet.size() == 1 && tenants.get(0).equals(ALL_TENANTS)) {
                Set<String> allTenants = this.instanceLifecycleManager.getAllTenants(true);
                if (allTenants.isEmpty()) {
                    throw new ParameterError("No subscribed tenants found");
                }
                tenantSet = allTenants;
            }
            Map<String, Object> result = this.provisioningService.upgradeAll(tenantSet, asynchronously);
            if (!asynchronously && this.exits.getInitDbExit() != null) {
                this.exits.getInitDbExit().onAfterInitDb(true);
            }
            return result;
        }
        catch (InternalError e) {
            if (!asynchronously && this.exits.getInitDbExit() != null) {
                this.exits.getInitDbExit().onAfterInitDb(false);
            }
            throw e;
        }
    }

    private void checkSaasRegistryUrl(String saasRegistryUrl) throws ParameterError {
        if (StringUtils.isBlank((CharSequence)saasRegistryUrl)) {
            throw new ParameterError("Saas registry URL is empty");
        }
    }

    public static final class Builder {
        private Exits exits;
        private SecurityChecker securityChecker;
        private SaasRegistry saasRegistry;
        private String baseUiUrl;
        private String urlSeparator;
        private ProvisioningServiceSpecification provisioningServiceSpecification;
        private InstanceLifecycleManager instanceLifecycleManager;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder exits(Exits exits) {
            this.exits = exits;
            return this;
        }

        public Builder securityChecker(SecurityChecker securityChecker) {
            this.securityChecker = securityChecker;
            return this;
        }

        public Builder saasRegistry(SaasRegistry saasRegistry) {
            this.saasRegistry = saasRegistry;
            return this;
        }

        public Builder provisioningServiceSpecification(ProvisioningServiceSpecification provisioningServiceSpecification) {
            this.provisioningServiceSpecification = provisioningServiceSpecification;
            return this;
        }

        public Builder baseUiUrl(String baseUiUrl) {
            this.baseUiUrl = baseUiUrl;
            return this;
        }

        public Builder urlSeparator(String urlSeparator) {
            this.urlSeparator = urlSeparator;
            return this;
        }

        public Builder instanceLifecycleManager(InstanceLifecycleManager instanceLifecycleManager) {
            this.instanceLifecycleManager = instanceLifecycleManager;
            return this;
        }

        public SubscriberStreamlinedMtx build() throws InternalError {
            if (this.provisioningServiceSpecification == null) {
                throw new InternalError("No provisioning service specification provided");
            }
            if (this.exits == null) {
                throw new InternalError("No exits provided");
            }
            if (this.securityChecker == null) {
                throw new InternalError("No security checker provided");
            }
            if (this.instanceLifecycleManager == null) {
                throw new InternalError("No instance lifecycle manager provided");
            }
            ProvisioningService provisioningService = new ProvisioningService(this.provisioningServiceSpecification.getUrl(), this.provisioningServiceSpecification.getResilienceConfig(), this.provisioningServiceSpecification.getAuthenticator());
            return new SubscriberStreamlinedMtx(this.exits, this.baseUiUrl, this.urlSeparator, this.securityChecker, this.saasRegistry, provisioningService, this.provisioningServiceSpecification.getPolling(), this.instanceLifecycleManager);
        }
    }
}

