/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cloud.mt.subscription.FilterTenants;
import com.sap.cloud.mt.subscription.UiUrlCreator;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.cloud.mt.subscription.exceptions.ParameterError;
import com.sap.cloud.mt.subscription.exits.SubscribeExit;
import com.sap.cloud.mt.subscription.json.Cloner;
import com.sap.cloud.mt.subscription.json.SubscriptionPayload;
import java.net.URL;
import java.time.Duration;
import java.util.List;

public class Tools {
    public static final String SECURE_CHARS = "^[_a-zA-Z0-9\\-]+$";
    private static final ObjectMapper objectMapper = new ObjectMapper();

    private Tools() {
    }

    public static void checkExternalTenantId(String tenantId) throws ParameterError {
        if (!FilterTenants.realTenants().test(tenantId)) {
            throw new ParameterError("Tenant Id is identical to a technical container");
        }
        Tools.checkTenantIdCharacters(tenantId);
    }

    public static void checkExternalTenantIds(List<String> tenantIds) throws ParameterError {
        for (String tenantId : tenantIds) {
            Tools.checkExternalTenantId(tenantId);
        }
    }

    public static void checkTenantIdCharacters(String tenantId) throws ParameterError {
        if (!tenantId.matches(SECURE_CHARS)) {
            throw new ParameterError("Tenant id contains forbidden characters");
        }
    }

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    public static void waitSomeTime(Duration waitTime) {
        try {
            Thread.sleep(waitTime.toMillis());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static String getApplicationUrl(SubscriptionPayload subscriptionPayload, SubscribeExit subscribeExit, String baseUiUrl, String urlSeparator) throws InternalError, ParameterError {
        String applicationUrl;
        if (subscriptionPayload == null) {
            throw new ParameterError("No subscription payload available");
        }
        if (subscriptionPayload.subscribedSubdomain == null) {
            throw new ParameterError("No sub domain passed in subscription payload");
        }
        URL urlFromExit = subscribeExit.uiURL();
        if (urlFromExit == null) {
            urlFromExit = subscribeExit.uiURL(Cloner.clone(subscriptionPayload));
        }
        String string = applicationUrl = urlFromExit != null ? urlFromExit.toExternalForm() : null;
        if (applicationUrl == null) {
            applicationUrl = UiUrlCreator.createUrl(subscriptionPayload.subscribedSubdomain, baseUiUrl, urlSeparator);
        }
        return applicationUrl;
    }
}

